#include <stdarg.h>
#include "LinkList.h"
#include "StrHier.h"
#include "libCfg.h"

#define MAXARGS 10

/*
 * LinkList List - root to tree to start query
 *
 * This routine returns a node defined by its number. Routine takes a
 * varing number of args to query a specific node. Last argument must be 0.
 */

static ByTe_1 rcsid[] = "$Id: SourceByNum.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

StrHier SourceByNum(LinkList List, ...)
{
   va_list ap;
   int *arg, args[MAXARGS];
   int argno = 0;

   LinkList L;
   static StrHier S;
   int number;


   va_start (ap, List);

   number = va_arg(ap, int);

   while ((args[argno++] = va_arg(ap, int)) != (int)0);

   va_end (ap);

   for (L=List; L != NULL; L=L->next)
   {
      S = (StrHier)L->data;

      if (SNUM(S) ==  number)
      {
         for(arg=args; *arg != 0; arg++)
         {
            if ((S = SourceByNum(SUBLIST(S), *arg, 0)) == NULL)
            {
               return (StrHier)NULL;
            }
         }
         return S;
      }
   }

   return (StrHier) NULL;
}
