/* StrHierCreateNodes -- create n number of nodes with string and sublist */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ant.h"
#include "Destroy.h"

static ByTe_1 rcsid[] = "$Id: SHCreateNodes.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

StrHier StrHierCreateNodes(int  n)
{
  StrHierNode *nodes;

  if(n <= 0) {
	fprintf(stderr,"ERROR: Input to StrHierCreateNodes is %d\n",n);
	return (StrHier)0;
  }
  /* create new node with its own copy of string */
  nodes = (StrHierNode *)calloc(n, sizeof(StrHierNode));

  nodes->Destroy = (DestroyObj_t *)calloc(1, sizeof(DestroyObj_t));
  nodes->Destroy->NToFree = n;
  nodes->Destroy->Free = DestroyStrHier;

  return nodes;
}
