#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"
#include "DbDefs.h"
#include "Destroy.h"
#include "libCfg.h"

/*
 * int n - the number of ItemValue structure to create
 *
 * Initializes ItemValue structures and attaches to it the destroy routine for
 * freeing up memory.
 */

static ByTe_1 rcsid[] = "$Id: CreateIValue.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

ItemValue_t *CreateItemValue(int  n)
{
   ItemValue_t *I, *i;
   DestroyObj_t *D;
   
   if (!(I = (ItemValue_t *)calloc(n, sizeof(ItemValue_t))))
   {
      return NULL;
   }

   if (!(D = (DestroyObj_t *)calloc(1, sizeof(DestroyObj_t))))
   {
      free((ByTe_1*)I);
      return NULL;
   }

   for (i=I; i<I+n-1; i++)
   {
      i->next = i + 1;
   }
   i->next = (ItemValue_t *)0;
   i->n_Values = 0;

   D->NToFree = n;
   D->Free    = DestroyItemValue;
   
   I->Destroy = D;

   return I;
}
