#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: process_symbol.c,v 1.1 1999/11/12 19:57:32 chris.gurgiolo.b2r Stab chrisg $";

void process_symbol(def_t *deflist, ByTe_1 *symbol)
{
   ByTe_1      **ptr_str, *end, *token;
   int       ival, *ptr_ival, i, frst;
   ByTe_2           *ptr_sval;
   ReaL_4           *ptr_fval;
   ReaL_8    dval, *ptr_dval;

/*
   Process the value symbol in accordance with the type field of the
   definition list entry.
*/
   switch (deflist->type)
   {
      case T_CHAR:
/*
   If the type is char the value symbol can have the form of a single character
   between single quotes (i.e. '*') or it can be an integer in base 8, 10, or
   16 (C conventions for the formats).  Determine which it is and process
   accordingly.
*/
         if (symbol[0] == '\'' && symbol[2] == '\'')
         {
/*
   For the form '*', take the character between the single quotes and store it
   in the location pointed to by the value field of the definition list entry.
   Give the required field a negative value.
*/
            *((ByTe_1 *) (deflist->value)) = symbol[1];

            if (deflist->required > 0)
            {
               deflist->required = -deflist->required;
            }

            break;
         }
         else
         {
/*
   Try to interpret the symbol as an integer value which is stored in ival.
   If the conversion is successful and the character following the end of
   the conversion is a '\0' or whitespace, process the value.
*/
            ival = strtol(symbol, &end, 0);
            if (symbol != end && (*end == '\0' || isspace(*end)))
            {
/*
   If the absolute value of ival is greater than can be stored in 8 bits
   write a warning message to stderr.
*/
               if (abs(ival) > 255)
               {
                  fprintf(stderr,
                          "parse_config: Value out of range for char in\n");
                  fprintf(stderr, "\t%s\n", deflist->param);
               }
               else
               {
/*
   If ival is valid as an 8 bit integer, store it in the location pointed to
   by the value field of the definition list entry.  Give the required field
   of the entry a negative value.
*/
                  *((ByTe_1 *) (deflist->value)) = ival;

                  if (deflist->required > 0)
                  {
                     deflist->required = -deflist->required;
                  }
               }

               break;
            }
         }

/*
   If the symbol could not be successfully converted, write a warning
   message to stderr.
*/
         fprintf(stderr, "parse_config: Expected a char in\n");
         fprintf(stderr, "\t%s\n", deflist->param);

         break;


      case T_SHORT:
      case T_INT:
/*
   Try to interpret the symbol as an integer value which is stored in ival.
   If the conversion is successful and the character following the end of the
   conversion is a '\0' or whitespace, process the value.  If the symbol could
   not be successfully converted, write a warning message to stderr.
*/
         ival = strtol(symbol, &end, 0);
         if (symbol == end || (*end != '\0' && !isspace(*end)))
         {
            fprintf(stderr, "parse_config: Expected an %s for\n",
                    deflist->type==T_INT ? "int" : "short");
            fprintf(stderr, "\t%s -> %s\n", deflist->param, symbol);
         }
         else
         {
            if (deflist->type == T_SHORT)
            {
/*
   If the absolute value of ival is greater than can be stored in 16 bits
   write a warning message to stderr (for a short only).
*/
               if (abs(ival) > 65535)
               {
                  fprintf(stderr,
                       "parse_config: Value out of range for short in\n");
                  fprintf(stderr, "\t%s\n", deflist->param);
               }
               else
               {
/*
   If ival is valid as a 16 bit integer, store it in the location pointed to
   by the value field of the definition list entry.  Give the required field
   of the entry a negative value.
*/
                  *((ByTe_2 *) (deflist->value)) = ival;
               }
            }
            else
            {
/*
   Store ival in the location pointed to by the value field of the definition
   list entry.  Give the required field of the entry a negative value.
*/
               *((int *) (deflist->value)) = ival;
            }

            if (deflist->required > 0)
            {
               deflist->required = -deflist->required;
            }
         }

         break;

      case T_FLOAT:
      case T_DOUBLE:
/*
   Try to interpret the symbol as a floating point value which is stored in
   dval.  If the conversion is successful and the character following the end
   of the conversion is a '\0' or whitespace, process the value.
*/
         dval = strtod(symbol, &end);
         if (symbol == end || (*end != '\0' && !isspace(*end)))
         {
            fprintf(stderr, "parse_config: Expected a %s in\n",
                    deflist->type==T_FLOAT ? "float" : "double");
            fprintf(stderr, "\t%s -> %s\n", deflist->param, symbol);
         }
         else
         {
/*
   If the absolute value of dval is outside the valid range for a
   float, write a warning message to stderr.
*/
            if (deflist->type == T_FLOAT)
            {
               if (fabs(dval) > FLT_MAX || fabs(dval) < FLT_MIN)
               {
                  fprintf(stderr,
                       "parse_config: Value out of range for float in\n");
                  fprintf(stderr, "\t%s\n", deflist->param);
               }
               else
               {
/*
   If dval is valid as a float, store it in the location pointed to by the
   value field of the definition list entry.  Give the required field of the
   entry a negative value.
*/
                  *((ReaL_4 *) (deflist->value)) = dval;
               }
            }
            else
            {
                  *((ReaL_8 *) (deflist->value)) = dval;
            }

            if (deflist->required > 0)
            {
               deflist->required = -deflist->required;
            }
         }

         break;

      case T_STRING:
      case T_STRPTR:
/*
   Try to interpret the symbol as a string of characters delimited by double
   quotes.   Associate symbol with the first character after the first quote
   and end with the location of the ending quote.  If an ending quote cannot
   be found to match the first, write a warning message to stderr.
 */
         if (symbol[0] == '"')
         {
            end = symbol += 1;
            for (; *end != '\0' && *end != '"'; end++);

            if (*end != '"')
            {
               fprintf(stderr, "parse_config: Unbalanced quotes for\n");
               fprintf(stderr, "\t%s -> %s\n", deflist->param, symbol);
            }
            else
            {
/*
   NULL delimit the symbol string and copy it to the location pointed to by
   the value field of the current definition list entry.  Give the required
   field of the entry a negative value.
*/
               *end = '\0';

               if (deflist->type == T_STRING)
               {
                  strcpy((ByTe_1 *) (deflist->value), symbol);
               }
               else
               {
                  (deflist->value) = (ByTe_1*)DupStr(symbol);
               }

               if (deflist->required > 0)
               {
                  deflist->required = -deflist->required;
               }
            }
         }
         else
         {
/*
   If the symbol could not be successfully converted, write a
   warning message to stderr.
*/
            fprintf(stderr, "parse_config: Expected a string for\n");
            fprintf(stderr, "\t%s -> %s\n", deflist->param, symbol);
         }

         break;

      case T_SHORT_ARRY:
      case T_INT_ARRY:

         if (deflist->type == T_SHORT_ARRY)
            ptr_sval = (ByTe_2 *) calloc(1, sizeof(ByTe_2));
         else
            ptr_ival = (int *) calloc(1, sizeof(int));

         token = strtok(symbol, " ");

         frst = 1;
         i = 0;
         do
         {
            ival = strtol(token, &end, 0);

            if (token == end || (*end != '\0' && !isspace(*end)))
            {
               fprintf(stderr, "parse_config: Expected an %s value for\n",
                       deflist->type == T_INT_ARRY ? "int" : "short");
               fprintf(stderr, "\t%s[%d] -> %s\n", deflist->param, i, token);
               break;
            }
            else
            {
               if (deflist->type == T_SHORT_ARRY)
               {
/*
   If the absolute value of ival is greater than can be stored in 16 bits
   write a warning message to stderr (for a short only).
*/
                  if (abs(ival) > 65535)
                  {
                     if (frst)
                     {
                        fprintf(stderr,
                          "parse_config: Value(s) out of range for a short:\n");
                        frst = 0;   
                     }
                     fprintf(stderr, "\t%s[%d] -> %s\n",
                             deflist->param, i, token);
                     ival = 0;
                  }
/*
   If ival is valid as a 16 bit integer, store it in the location pointed to
   by the value field of the definition list entry.  Give the required field
   of the entry a negative value.
*/
                  ptr_sval = (ByTe_2 *) realloc(ptr_sval,
                                               (i+1) * sizeof(ByTe_2));

                  *((ByTe_2 **) (deflist->value)) = ptr_sval;

                  *(ptr_sval+i++) = ival;
               }
               else
               {
/*
   Store ival in the location pointed to by the value field of the definition
   list entry.  Give the required field of the entry a negative value.
 */
                  ptr_ival = (int *) realloc(ptr_ival, (i+1) * sizeof(int));

                  *((int **) (deflist->value)) = ptr_ival;

                  *(ptr_ival+i++) = ival;
               }

               if (deflist->required > 0)
               {
                  deflist->required = -deflist->required;
               }
            }

            token = strtok(NULL, " ");
            
         } while (token);

         deflist->n_values = i;

         break;

      case T_FLOAT_ARRY:

         ptr_fval = (ReaL_4 *) calloc(1, sizeof(ReaL_4));
         token = strtok(symbol, " ");

         frst = 1;
         i = 0;
         do
         {
/*
   Try to interpret the symbol as a floating point value which is stored in
   dval.  If the conversion is successful and the character following the end
   of the conversion is a '\0' or whitespace, process the value.
*/
            dval = strtod(token, &end);

            if (token == end || (*end != '\0' && !isspace(*end)))
            {
               fprintf(stderr, "parse_config: Expected a float value for\n");
               fprintf(stderr, "\t%s[%d] -> %s\n", deflist->param, i, token);
               break;
            }
            else
            {
/*
   If the absolute value of dval is outside the valid range for a
   float, write a warning message to stderr.
*/
               if (fabs(dval) > FLT_MAX || fabs(dval) < FLT_MIN)
               {
                  if (frst)
                  {
                     fprintf(stderr,
                             "parse_config: Value out of range for float in\n");
                     frst = 0;
                  }
                  fprintf(stderr, "\t%s\n", deflist->param);
                  dval = 0;
               }
               else
               {
/*
   If dval is valid as a float, store it in the location pointed to by the
   value field of the definition list entry.  Give the required field of the
   entry a negative value.
*/
                  ptr_fval = (ReaL_4 *) realloc(ptr_fval,
                                               (i+1) * sizeof(ReaL_4));

                  *((ReaL_4 **) (deflist->value)) = ptr_fval;

                  *(ptr_fval+i++) = dval;
               }
            }

            if (deflist->required > 0)
            {
               deflist->required = -deflist->required;
            }

            token = strtok(NULL, " ");
            
         } while (token);

         deflist->n_values = i;

         break;

      case T_DOUBLE_ARRY:

         ptr_dval = (ReaL_8 *) calloc(1, sizeof(ReaL_8));
         token = strtok(symbol, " ");

         frst = 1;
         i = 0;
         do
         {
/*
   Try to interpret the symbol as a floating point value which is stored in
   dval.  If the conversion is successful and the character following the end
   of the conversion is a '\0' or whitespace, process the value.
*/
            dval = strtod(token, &end);

            if (token == end || (*end != '\0' && !isspace(*end)))
            {
               fprintf(stderr, "parse_config: Expected a float value for\n");
               fprintf(stderr, "\t%s[%d] -> %s\n", deflist->param, i, token);
               break;
            }
            else
            {
/*
   If the absolute value of dval is outside the valid range for a
   float, write a warning message to stderr.
*/
               if (fabs(dval) > DBL_MAX || fabs(dval) < DBL_MIN)
               {
                  if (frst)
                  {
                     fprintf(stderr,
                            "parse_config: Value out of range for double in\n");
                     frst = 0;
                  }
                  fprintf(stderr, "\t%s\n", deflist->param);
                  dval = 0;
               }
               else
               {
/*
   If dval is valid as a float, store it in the location pointed to by the
   value field of the definition list entry.  Give the required field of the
   entry a negative value.
*/
                  ptr_dval = (ReaL_8 *) realloc(ptr_dval,
                                               (i+1) * sizeof(ReaL_8));

                  *((ReaL_8 **) (deflist->value)) = ptr_dval;

                  *(ptr_dval+i++) = dval;
               }
            }

            if (deflist->required > 0)
            {
               deflist->required = -deflist->required;
            }

            token = strtok(NULL, " ");
            
         } while (token);

         deflist->n_values = i;

         break;

      case T_STRPTR_ARRY:

         ptr_str = (ByTe_1 **) calloc(1, sizeof(ByTe_1 *));

         token = symbol;
         i = 0;
         do
         {
/*
   Try to interpret the symbol as a string of characters delimited by double
   quotes.   Associate symbol with the first character after the first quote
   and end with the location of the ending quote.  If an ending quote cannot
   be found to match the first, write a warning message to stderr.
 */
            if (token[0] == '"')
            {
               end = token += 1;
               for (; *end != '\0' && *end != '"'; end++);

               if (*end != '"')
               {
                  fprintf(stderr, "parse_config: Unbalanced quotes for\n");
                  fprintf(stderr, "\t%s[%d] -> %s\n", deflist->param, i, token);
               }
               else
               { 
/*            
   NULL delimit the symbol string and copy it to the location pointed to by
   the value field of the current definition list entry.  Give the required
   field of the entry a negative value.
*/            
                  *end = '\0';
              
/*
   NULL delimit the symbol string and copy it to the location pointed to by
   the value field of the current definition list entry.  Give the required
   field of the entry a negative value.
*/

                  ptr_str = (ByTe_1 **) realloc(ptr_str, (i+1) * sizeof(ByTe_1 *));

                  deflist->value = (void *)ptr_str;

                  *(ptr_str+i) = DupStr(token);
		  i++;

                  if (deflist->required > 0)
                  {
                     deflist->required = -deflist->required;
                  }
               }

               for (token = end+1; *token != '\0' && isspace(*token); token++);
            }
            else
            {
/*
   If the symbol could not be successfully converted, write a
   warning message to stderr.
*/
               fprintf(stderr, "parse_config: Expected a string for\n");
               fprintf(stderr, "\t%s[%d] -> %s\n", deflist->param, i, token);

               end = token;
               for (token = end+1; *token != '\0' && !isspace(*token); token++);
            }
            
         } while (*token);

         deflist->n_values = i;

         break;

      default:
/*
   If the conversion type specification in the current definition list
   entry is unknown, report the error to stderr.
*/
         fprintf(stderr, "parse_config: Unknown type expected in %s\n",
                 deflist->param);

         break;
   }
}

