#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: pc_get_tokens.c,v 1.1 1999/11/12 19:57:32 chris.gurgiolo.b2r Stab chrisg $";

int pc_get_tokens(FILE *fp, ByTe_1 **oparam, ByTe_1 **ovalue, 
                       ByTe_1 **buffer, int *bufsize)
{
   ByTe_1 *end, *param, *value;
   ByTe_1 *line;
   int  esc;

/*
   Initialize oparam and ovalue to NULL.
*/
   *oparam = *ovalue = NULL;

/*
   Get a line from the input stream.  If pc_get_line returns a
   NULL, then the input stream has terminated. In that case return a
   -1 to the calling routine.
*/
   if ((line = pc_get_line(fp, buffer, bufsize)) == NULL)
   {
      return -1;
   }

/*
   Find the first non-whitespace character in line and associate the
   pointer param with that location.
*/
   for (param = line; isspace(*param); param++);

/*
   If the first non-whitespace character is '#' or '\0', then the line is
   a comment or empty. In that case return a 0 to indicate no param or value
   found.
*/
   if (*param == '#' || *param == '\0')
   {
      return 0;
   }

/*
   Find the first character that follows that is not alphanumeric or
   punctuation.
*/
   for (end = param ; (isalnum(*end) || ispunct(*end)) ; end++);

/*
   If the end character is not whitespace, report an error to stderr
   and return 0.
*/
   if (!isspace(*end))
   {
      (void)fprintf(stderr, "open_config.pc_get_tokens: ");
      (void)fprintf(stderr, "Non-whitespace terminating name field\n");
      (void)fprintf(stderr, "---->%s\n", line);
      (void)fflush(stderr);

      return 0;
   }

/*
   Write a '\0' at the end of the param string.
*/
   *end = '\0';

/*
   Set oparam to point to the location in line indicated by param.
*/
   *oparam = param;

/*
   Set value to point at the remainder of the line.  Advance to the
   first non-whitespace character.
*/
   for (value = end + 1 ; isspace(*value) ; value++);

/*
   If the first non-whitespace character is a '#' or '\0', then the end
   of the line was reached or the remainder of the line is a comment and
   there was no value field.  In this case report an error and return 1.
*/
   if (*value == '#' || *value == '\0')
   {
      (void)fprintf(stderr, "open_config.pc_get_tokens: ");
      (void)fprintf(stderr, "No parameter value field found\n");
      (void)fprintf(stderr, "---->%s\n", line);
      (void)fflush(stderr);

      return 1;
   }

/*
   Find the end of the definition value field in the string pointed to by
   value.  The value field is defined to be composed of any character
   except '#', unless the '#' is escaped by a backslash, like '\#'.
   Anything on a line following an unescaped '#' is a comment and is ignored.
   Trailing white space between the last non-whitespace character and the
   end of the line or beginning of the comment is ignored.  A '\0' is written
   after the last element of the value field.
*/
   for (end = value, esc = 0; *end != '\0' ; end++)
   {
      if (esc)
      {
         esc = 0;
      }
      else if (*end == '\\')
      {
         esc = 1;
      }
      else if (*end == '#')
      {
         break;
      }
   }

   for (end-- ; isspace(*end) ; end--);

   *(++end) = '\0';

/*
   Set ovalue to point to the location in line indicated by value.
*/
   *ovalue = value;

/*
   Return a 2 to indicate that a param and a value have been found.
*/
   return 2;
}
