#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: pc_destroy_config.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

config_t * pc_destroy_config(config_t *ch)
{
   int i, j;

/*
   Free all used symbol table element param and value strings.
   Free all the symbol table arrays in the config structure.
*/
   for (i = 0 ; i < CONFIG_TABLE_WIDTH ; i++)
   {
      for (j = 0 ; j < ch->used[i] ; j++)
      {
         if (ch->symbols[i][j].param != NULL)
         {
            (void)free(ch->symbols[i][j].param);
         }

         if (ch->symbols[i][j].value != NULL)
         {
            (void)free(ch->symbols[i][j].value);
         }
      }

      if (ch->symbols[i] != SNULL)
      {
         (void)free((ByTe_1 *)ch->symbols[i]);
      }
   }

/*
   Free the config structure.
*/
   (void)free((ByTe_1 *)ch);

/*
   Return a NULL to the calling routine.
*/
   return 0x0;
}
