#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: pc_add_symbol.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

int pc_add_symbol(config_t *ch, ByTe_1 *param, ByTe_1 *value)
{
   int    elements, index, used;
   int    bytes;
   symb_t *symbols;

/*
   Get the index to the symbol array to use from the first character of the
   param modulo the table width.  Get local copies of the symbols, elements,
   and used array elements for the index location.
*/
   index = *param % CONFIG_TABLE_WIDTH;

   symbols  = ch->symbols[index];
   elements = ch->elements[index];
   used     = ch->used[index];

/*
   If the symbols value is NULL or all the allocated elements have been used,
   then grow symbols by a basic unit of symbols.  Increment the elements
   value for this location.  If there is an error, report it and return -1.
   Copy the local values of symbols and elements back to the array locations
   in the config structure.
*/

   if (symbols == SNULL || used == elements)
   {
      elements += ALLOC_ATOM;

      bytes = elements * sizeof(symb_t);
      if (symbols == SNULL)
         symbols = (symb_t *)malloc(bytes);
      else
         symbols =  (symb_t *)realloc((ByTe_1 *)symbols, bytes);
      if (symbols == SNULL)
      {
         perror("open_config.pc_add_symbol");
         return -1;
      }

      ch->symbols[index]  = symbols;
      ch->elements[index] = elements;
   }

/*
   Copy the param and value strings into allocated storage and associate
   the param and value pointers in the first unused symbols array element.
   Set the referenced field of the symbols array element to zero. 
   If there is an error, report it and return -1.  If the error is in the
   second DupStr call, free the first allocated string.  Increment the used
   value for this location.
*/
   if ((symbols[used].param = DupStr(param)) == NULL)
   {
      perror("open_config.pc_add_symbol.DupStr(param)");
      return -1;
   }

   if ((symbols[used].value = DupStr(value)) == NULL)
   {
      perror("open_config.pc_add_symbol.DupStr(value)");
      (void)free(symbols[used].param);
      return -1;
   }

   symbols[used].referenced = 0;

   ch->used[index]++;

/*
   Return a zero to indicate success.
*/

   return 0;
}
