#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <float.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: get_symbol.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 * get_symbol(config_t *ch, ByTe_1 *param)
{
   ByTe_1   *value;
   int    i, index, used;
   symb_t *symbols;

/*
   Initialize value to NULL.
   Get the index to the symbol array to use from the first character of the
   param modulo the table width.  Get local copies of the symbols and used
   array elements for the index location.
*/
   value = NULL;

   index = *param % CONFIG_TABLE_WIDTH;

   symbols  = ch->symbols[index];
   used     = ch->used[index];

/*
   Check symbols to see if it is NULL.  If it is not, continue.
   Compare each used element of the symbols array with param to see if
   there is a match.  If there is and the element has not been previously
   referenced, return the value pointer to the calling routine.  Set the
   referenced flag for the element.
*/
   if (symbols != SNULL)
   {
      for (i = 0 ; i < used ; i++, symbols++)
      {
         if (!symbols->referenced && !strcmp(symbols->param, param))
         {
            value = symbols->value;
            symbols->referenced = 1;

            break;
         }
      }
   }

/*
   Return value to the calling routine.
*/
   return value;
}
