#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libCfg.h"

static ByTe_1 rcsid[] = "$Id: aConfig.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

LinkList aConfig(config_t *handle, ByTe_1 *prefix, StrHier parent)
{
   static int level = 0;
   LinkList L = NULL;
   StrHier S;

   static def_t deflist[] =
   {
      {"Strings", T_STRPTR_ARRY, (void *)NULL, IS_REQUIRED},
      {NULL},
   };
   ByTe_1 new_prefix[80];
   int n_strings, i;


   memset(new_prefix, 0, sizeof(new_prefix));

   deflist[0].required = IS_REQUIRED;
   if (parse_config(handle, prefix, deflist) != 0)
   {
      return NULL;
   }

   n_strings = deflist[0].n_values;

   if (!(S=StrHierCreateNodes(n_strings))) { return NULL; }

   for (i=0; i<n_strings; i++)
   {
      ByTe_1 *val, *pos;
      
      val = ((ByTe_1 **)deflist->value)[i];
      S[i].str = val;
      S[i].number = i+1;

      L = LinkAppend(L, (void *)&S[i]);
      S[i].parent = parent;

      pos = strstr(val, ".scf");
      
      if (pos)
         S[i].GetNextItems = ScfNextItems;
      else if (level == 4)
         S[i].GetNextItems = VidfNextItems;
      else
         S[i].GetNextItems = IdfsNextItems_sublist;
   }
   free(deflist->value);

   if (++level > 4)
   {
      level--;
      return L;
   }

   for (i=0; i<n_strings; i++)
   {
      if (S[i].GetNextItems == ScfNextItems)
         continue;

      if (prefix && strlen(prefix) != 0)
      {
         sprintf(new_prefix, "%s%s.", prefix, S[i].str);
      }
      else
      {
         sprintf(new_prefix, "%s.", S[i].str);
      }

      S[i].sublist = aConfig(handle, new_prefix, &S[i]);
   }

   level--;
   return L;
}
