#include <stdio.h>
#include <stdlib.h>
#include "libCfg.h"
#include "StrHier.h"
#include "Destroy.h"

/*
 * LinkList * - pointer to root of Projects tree
 *
 * This routine frees up all memory associated with the Projects tree
 */

static ByTe_1 rcsid[] = "$Id: P_Free.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

void aP_Free(LinkList P)
{
   StrHier  S;
   LinkList Last, NextToLast;
   DestroyObj_t *Destroy;


   if (P == (LinkList)0)
      return;

   S = (StrHier) P->data;

   NextToLast = (LinkList)0;
   for (Last=P ; Last->next; Last=Last->next)
      NextToLast=Last;

   S = (StrHier) Last->data;

   if (S->sublist)
   {
      aP_Free(S->sublist);

      S->sublist = (LinkList)0;

      if (P == Last)
      {
         Destroy = ((VoidFree_t *)Last->data)->Destroy;
         if (Destroy)
            (Destroy->Free)(Last->data);

         free(Last);

         return;
      }
   }
   else
   {
      Destroy = ((VoidFree_t *)Last->data)->Destroy;
      if (Destroy)
         (Destroy->Free)(Last->data);

      free(Last);

      if (NextToLast)
         NextToLast->next = (LinkList)0;
   }

   if (P != Last)
      aP_Free(P);

   return;
}
