#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"
#include "DbDefs.h"
#include "Destroy.h"
#include "libCfg.h"

/*
 * StrHier Source - node in Projects tree
 *
 * Return a static string to the Database path for the source.
 */

static ByTe_1 rcsid[] = "$Id: DbfFile.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 *DbfFile(StrHier Source)
{
   static ByTe_1 fname[256];

   ByTe_1 *path;
   ByTe_1 *Slash = PathSep;


   memset(fname, 0, sizeof(fname));

   if ((path = CfgPath(Source, "DatabasePath", 3)) == NULL)
   {
      return NULL;   
   }
   strcpy(fname, path);

   strcat(fname, Slash);
   strcat(fname, "Database");

   strcat(fname, Slash);
   strcat(fname, StrHierName(StrHierParent(Source)));

   return fname;
}
