#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "libCfg.h"
#include "OpSySInD.h"
#include "StrHier.h"
#include "ItemValue.h"
#include "Pconfig.h"
#include "ant.h"

/*
 * char     *file - configuration file name.
 * LinkList P     - root pointer to the Projects tree.
 *
 * Initialize the item-value information to defined nodes of the Projects tree.
 */
typedef struct GlobalItems_s
{
   ByTe_1 *Item;
   ByTe_1 **Values;
   int  Nvalues;
} GlobalItems_t;

int DB_Config(ByTe_1 *file, LinkList P)
{
   config_t *p_handle;

   int NGlobalItems;
   GlobalItems_t *GlobalItems;

   static int ncp = -1;
   static def_t def_items[] =
   {
      {"NCP", T_INT, (void *)&ncp, IS_OPTIONAL},
      {"ITEMS", T_STRPTR_ARRY, (void *)NULL, IS_REQUIRED},
      {NULL},
   };
   static def_t def_values[] =
   {
      {"VALUE", T_STRPTR_ARRY, (void *)NULL, IS_REQUIRED},
      {NULL},
   };

   int NLevels;
   static def_t def_levels[] =
   {
      {"LEVELS", T_STRPTR_ARRY, (void *)NULL, IS_REQUIRED},
      {NULL},
   };
   def_t *DefItems;

   ByTe_1 prefix[80], *token;
   LinkList L, I;
   StrHier S;
   int i, j, k, frst=1;

   ItemValue_t *ItemValue;

   /*
    |
    || get: 1. the number of concurrent processes defined
    ||      2. the defined items
    |
    */

   if ((p_handle = open_config(file)) == CNULL)
      return 0;

   /*
    | need to initialize these in case this routine is called more that once
    */

   def_items[0].required = IS_OPTIONAL;
   def_items[1].value    = NULL;
   def_items[1].required = IS_REQUIRED;
   if (parse_config(p_handle, NULL, def_items) != 0)
   {
      pc_destroy_config(p_handle);
      return 0;
   }

   /*
    | default the number of concurrent processes to 1 if it was not defined
    */
   if (ncp > 1) NCP = ncp;

   /*
    | the number of defined global items and allocate memory for each
    */
   NGlobalItems = def_items[1].n_values;
   GlobalItems = (GlobalItems_t *) calloc(NGlobalItems, sizeof(GlobalItems_t));

   if (!(DefItems = (def_t *)calloc((NGlobalItems + 1), sizeof(def_t))))
   {
      free(GlobalItems);
      pc_destroy_config(p_handle);
      return 0;
   }

   /*
    | get each value for each global item
    */
   for (i=0; i < NGlobalItems; i++)
   {
      ByTe_1 param[64];

      GlobalItems[i].Item = ((ByTe_1 **)def_items[1].value)[i];
      sprintf(prefix, "%s.", GlobalItems[i].Item);
      def_values[0].required = IS_REQUIRED;
      def_values[0].value    = NULL;
      parse_config(p_handle, prefix, def_values);
      GlobalItems[i].Nvalues = def_values[0].n_values;
      GlobalItems[i].Values = (ByTe_1 **)def_values[0].value;

      sprintf(param, "%s.VALUE", GlobalItems[i].Item);
      DefItems[i].param = DupStr(param);
      DefItems[i].type = T_STRPTR_ARRY;
      DefItems[i].value = NULL;
      DefItems[i].required = IS_OPTIONAL;
      DefItems[i].n_values = 0;
   }
   DefItems[i].param = NULL;

   /*
    | the number of defined levels for each global item
    */
   def_levels[0].value = NULL;
   def_levels[0].required = IS_REQUIRED;
   if (parse_config(p_handle, NULL, def_levels) != 0)
   {
      for (i=0; i<NGlobalItems; i++)
         free(GlobalItems[i].Values);
      free(GlobalItems);
      pc_destroy_config(p_handle);
      return 0;
   }
   NLevels = def_levels[0].n_values;

   /*
    | 
    */
   for (i=0; i < NLevels; i++)
   {
      ByTe_1 *Level;

      Level = ((ByTe_1 **)def_levels[0].value)[i];

      sprintf(prefix, "%s.", Level);
      for (j=0; j < NGlobalItems; j++)
      {
         DefItems[j].required = IS_OPTIONAL;
         DefItems[j].value = NULL;
      }

      parse_config(p_handle, prefix, DefItems);

      if ((ItemValue = CreateItemValue(NGlobalItems)) == NULL)
      {
         for (j=0; j<NGlobalItems; j++)
            free(GlobalItems[j].Values);
         free(GlobalItems);
         pc_destroy_config(p_handle);
         return 0;
      }

      for (j=0; j< NGlobalItems; j++)
      {
         ItemValue[j].Item  = DupStr(GlobalItems[j].Item);
         if (DefItems[j].value != NULL)
         {
            ItemValue[j].Value = (ByTe_1 **)DefItems[j].value;
            ItemValue[j].n_Values = DefItems[j].n_values;
         }
         else
         {
            int i;

            ItemValue[j].Value = (ByTe_1 **)calloc(GlobalItems[j].Nvalues, sizeof(ByTe_1 *));
            for (i=0; i < GlobalItems[j].Nvalues; i++)
               ItemValue[j].Value[i] = DupStr(GlobalItems[j].Values[i]);

            ItemValue[j].n_Values = GlobalItems[j].Nvalues;
         }

         {
            ByTe_2 cntr, len;
            ByTe_1 env[64], *s, *c = *ItemValue[j].Value;

            for (k=0; k< ItemValue[j].n_Values; k++)
            {
               c = ItemValue[j].Value[k];

               if (*c++ == '$')  /* need to expand any environment variables */
               {
                  cntr = 0;
                  while (isalnum(*c) || *c == '_' || *c == '-')
                  {
                     env[cntr++] = *c++;
                     if (cntr > 60)
                        break;
                  }
                  if (cntr == 0)
                     continue;
                  else
                     env[cntr] = '\0';

                  if ((c = getenv(env)))
                  {
                     len = strlen(&ItemValue[j].Value[k][cntr+1]);
                     len += strlen(c) + 1;
                     s = calloc(len, 1);
                     sprintf(s, "%s%s", c, &ItemValue[j].Value[k][cntr+1]);
                     free(ItemValue[j].Value[k]);
                     ItemValue[j].Value[k] = s;
                  }
               }
            }
         } /* block */
      } /* for (j=0; j< NGlobalItems; j++) */

      I = P;
      token = strtok(Level, ":");
      do
      {
         for (L = I; L != NULL; L = L->next)
         {
            S = (StrHier) L->data;
            if (strcmp(token, S->str) == 0)
               break;
         }

         if (L == NULL)
         {
            if (frst)
               frst = 0;
            break;
         }
         S = (StrHier)L->data;
         I = S->sublist;

      } while ((token = strtok(NULL, ":")));

      if (L == NULL || S->info != NULL)
      {
         for (j=0; j<NGlobalItems; j++)
         {
            free(ItemValue[j].Item);
            for (k=0; k<ItemValue[j].n_Values; k++)
               free(ItemValue[j].Value[k]);

            free(ItemValue[j].Value);
         }
         free(ItemValue->Destroy);
         free(ItemValue);
         continue;
      }

      S->info = (void *)ItemValue;

   }

   for (i=0; i<def_levels[0].n_values; i++)
      free(((ByTe_1 **)def_levels[0].value)[i]);
   free(def_levels[0].value);

   for (i=0; i<NGlobalItems; i++)
   {
      for (j=0; j < GlobalItems[i].Nvalues; j++)
         free(GlobalItems[i].Values[j]);

      free(GlobalItems[i].Item);
      free(GlobalItems[i].Values);
      free(DefItems[i].param);
   }

   free(GlobalItems);
   free(def_items[1].value);
   free(DefItems);

   pc_destroy_config(p_handle);

   return 1;
}
