#include "OpSySInD.h"
#include <memory.h>
#include <string.h>
#include "libCfg.h"

/*
 * StrHier Source - node in the Projects tree for start of query
 * char    *item  - string for query
 * int     level  - level in tree to add directory node names
 *
 * Return static character string to data path defined by item value. Additional
 * path information is added based on parent name of the Source.  The number of
 * path names added is dependent upon the level.
 */

static ByTe_1 rcsid[] = "$Id: CfgPath.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 *CfgPath(StrHier Source, ByTe_1 *item, int level)
{
   StrHier S;
   static ByTe_1 path[256];
   ByTe_1 *p;
   ByTe_1 *Slash = PathSep;
   int i, j;
   ItemValue_t *I;

   for (S=Source; S; S=S->parent)
   {
      I = (ItemValue_t *)S->info;
      if ((p = FindItemValue(I, item, 0)))
         break;
   }

   if (!S || p == NULL)
      return NULL;

   memset(path, 0, 256);
   strcpy(path, p);
   if (path[strlen(path)-1] != '%')
   {
      for (i=0,S=Source; StrHierParent(S); S=StrHierParent(S),i++);
      i--;
      for (; --level >= 0;)
      {
         strcat(path, Slash);
         strcat(path, SNAME(S));
			for (j=--i,S=Source; j>=0; S=StrHierParent(S),j--);
      }
   }
   else
      path[strlen(path)-1] = '\0';

   return path;
}
