#include "util_str.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                              IR_SET_TIME SUBROUTINE                        *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine determines the time associated with the data set being     *
 *  returned by the READ_DREC() routine.  The time for the first data value   *
 *  is returned for the start time and the time for the last data value is    *
 *  returned for the end time.                                                *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    char full_swp              flag that indicates if 1 value is being      *
 *                               requested or all values for the record (for  *
 *                               a scalar parameter only)                     *
 *    void *UDF                  ptr to the memory location for the structure *
 *                               that holds returned data values (read_drec)  *
 *    char *decrement_bday       flag indicating if start day needs to be     *
 *                               modified (if btime ends up negative)         *
 *    char *decrement_eday       flag indicating if end day needs to be       *
 *                               modified (if etime ends up negative)         *
 *                                                                            *
 *  USAGE                                                                     *
 *    ir_set_time (full_swp, UDF, &decrement_bday, &decrement_eday)           *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    ir_sample_time ()          returns the time associated with a single    *
 *                               data sample (row, column)                    *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    struct general_info        structure that holds information concerning  *
 *        ginfo                  the experiment that is being processed       *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct idf_data *ExDa      structure that holds all of the currently    *
 *                               returned data values to be processed         *
 *    struct experiment_info     a pointer to the structure that holds        *
 *          *ex                  specific experiment information              *
 *    struct ptr_rec *ptr        a pointer to the structure which holds all   *
 *                               pointers to the header and data for the      *
 *                               experiment of interest                       *
 *    unsigned short max_ele     the number of data values to be returned     *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

void ir_set_time (ByTe_1 full_swp, void *UDF, ByTe_1 *decrement_bday, 
                  ByTe_1 *decrement_eday)
{
  extern struct general_info ginfo;

  struct idf_data *ExDa;
  struct experiment_info *ex;
  struct ptr_rec *ptr;
  u_ByTe_2 max_ele;

  /****************************************************************************/
  /*  Set a pointer to the structure which holds all pointers for header and  */
  /*  data information for the experiment currently being processed and point */
  /*  to the sensor structure for the sensor of interest.                     */
  /****************************************************************************/

  ex  = ginfo.expt;
  ptr = ex->info_ptr;

  /**************************************************************************/
  /*  These time elements are returned to the user as floating point values.*/
  /**************************************************************************/

  ExDa = (struct idf_data *) UDF;
  ExDa->sen_reset_ms = ex->sen_ms;
  ExDa->sen_reset_ns = ex->sen_ns;
  ExDa->swp_reset_ms = ex->swp_ms;
  ExDa->swp_reset_ns = ex->swp_ns;
  ExDa->data_lat_ms = ex->lat_ms;
  ExDa->data_lat_ns = ex->lat_ns;
  ExDa->data_accum_ms = ex->accum_ms;
  ExDa->data_accum_ns = ex->accum_ns;

  max_ele = (ex->smp_id == 2 && !full_swp) ? 1 : *ptr->N_SAMPLE - ptr->time_row;
  ir_sample_time (max_ele, UDF, (u_ByTe_2) ptr->time_row, ptr->time_col,
                  &ex->btime_ms, &ex->btime_ns, &ex->etime_ms, &ex->etime_ns,
                  decrement_bday, decrement_eday);
}
