#include "util_str.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                          GET_VERSION_NUMBER SUBROUTINE                      *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine returns the next available version number that can be used  *
 *  with the generic utility software.  This routine was written to safeguard  *
 *  against different applications using the same version number.              *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    unsigned short *vnum         the version number                          *
 *                                                                             *
 *  USAGE                                                                      *
 *    get_version_number (&vnum)                                               *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    struct general_info ginfo    structure that holds information concerning *
 *                                 the experiment that is being processed      *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    struct experiment_info *ex   a pointer to the structure that holds       *
 *                                 specific experiment information             *
 *    struct experiment_info       loop termination variable                   *
 *       *stop_ex                                                              *
 *    char reusable                flag indicating if a freed version can be   *
 *                                 utilized                                    *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void get_version_number (u_ByTe_2 *vnum)
{
   extern struct general_info ginfo;

   register struct experiment_info *ex, *stop_ex;
   ByTe_1 reusable;

   /**********************************************************************/
   /*  Check all ex structures since free_version_info leaves the ex     */
   /*  structures in the GINFO area and these versions may be re-used.   */
   /**********************************************************************/

   reusable = 0;
   ex = ginfo.exbase;
   stop_ex = ginfo.exbase + ginfo.nds;
   for (; ex < stop_ex; ++ex)
    {
      /*******************************************************************/
      /*  Re-usable version number found.                                */
      /*******************************************************************/

      if (ex->data_key == 0 && ex->version != 65535)
       {
         reusable = 1;
         *vnum = ex->version;
         ex->version = 65535;

         /*****************************************************************/
         /*  Find other re-usable ex structures with same version number  */
         /*  that exist AFTER this first found instance.                  */
         /*****************************************************************/

         for (++ex; ex < stop_ex; ++ex)
           if (ex->data_key == 0 && ex->version == *vnum)
             ex->version = 65535;

         break;
       }
    }

   if (!reusable)
    {
      *vnum = ginfo.next_version;
      ++ginfo.next_version;
    }
}
