#include "util_str.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                         FREE_VERSION_INFO SUBROUTINE                        *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine is called to free all allocated memory associated with the  *
 *  experiment_info structure(s) which are associated with the specified       *
 *  version number.                                                            *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    unsigned short vnum          version number to be associated with this   *
 *                                 combination (allows for multiple opens)     *
 *                                                                             *
 *  USAGE                                                                      *
 *    free_version_info (vnum)                                                 *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    ir_free_ex_structure()       frees all allocated memory associated with  *
 *                                 the specified experiment_info structure     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    struct general_info          structure that holds information concerning *
 *        ginfo                    the experiment that is being processed      *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    reg struct experiment_info   a pointer to the structure that holds       *
 *          *ex, *new_ex           specific experiment information             *
 *    reg struct experiment_info *stop_ex     loop termination variable        *
 *    short rval                   holds returned value from module            *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void free_version_info (u_ByTe_2 vnum)
{
  extern struct general_info ginfo;

  register struct experiment_info *ex, *stop_ex, *new_ex;
  ByTe_2 rval;

  /**************************************************************************/
  /*  Loop over all defined ex structures.                                  */
  /**************************************************************************/

  stop_ex = ginfo.exbase + ginfo.nds;
  for (ex = ginfo.exbase; ex < stop_ex; ++ex)
   {
     /******************************************************************/
     /*  The data_key should never be zero unless this module has been */
     /*  called and the system was never re-initialized.               */
     /******************************************************************/

     if (ex->version != vnum || ex->data_key == 0)
       continue;

     /******************************************************************/
     /*  Free pitch angle information, if applicable.                  */
     /******************************************************************/

     if (ex->pa_def && ex->bmem.base_pitch_info != NO_MEMORY)
      {
        rval = ir_locate_ex (ex->pitch_angles->data_key, ex->pitch_angles->exten,
                             ex->pitch_angles->version, 0);
        new_ex = ginfo.expt;
        ir_free_ex_structure (new_ex);
        new_ex->data_key = 0;
      }

     ir_free_ex_structure (ex);

     /******************************************************************/
     /*  Set the data_key to zero to flag when the system has not been */
     /*  re-initialized.                                               */
     /******************************************************************/
  
     ex->data_key = 0;
   }
}
