#include <stdio.h>
#include "util_str.h"
#include "ret_codes.h"
#include "libbase_udf.h"

/*****************************************************************************
 *                                                                           *
 *                      IDFS_ERROR_MESSAGE_STR SUBROUTINE                    *
 *                                                                           *
 *  DESCRIPTION                                                              *
 *    This routine is called to compose the error string encountered from    *
 *  the generic utility software, both libbase_idfs and libtrec_idfs.        *
 *                                                                           *
 *  INPUT VARIABLES                                                          *
 *    short error_code          the error code to be processed               *
 *    char *e_str               ptr to area where string is to be returned   *
 *                                                                           *
 *  USAGE                                                                    *
 *    x = idfs_error_message_str (error_code, e_str)                         *
 *                                                                           *
 *  NECESSARY SUBPROGRAMS                                                    *
 *    strcpy()                  copies a string to another string variable   *
 *    sprintf()                 creates a string based upon arguments and    *
 *                              conversion characters                        * 
 *                                                                           *
 *  EXTERNAL VARIABLES                                                       *
 *    struct general_info       structure holding information concerning     *
 *        ginfo                 the experiment that is being processed       *
 *                                                                           *
 *  INTERNAL VARIABLES                                                       *
 *    struct experiment_info    a pointer to the structure that holds        *
 *          *ex                 specific experiment information              *
 *    char e_str[]              holds the error string to be outputted       *
 *                                                                           *
 *  SUBSYSTEM                                                                *
 *    Display Level                                                          *
 *                                                                           *
 *****************************************************************************/

void idfs_error_message_str (ByTe_2 error_code, ByTe_1 *e_str)
{
   extern struct general_info ginfo;

   struct experiment_info *ex;

   /************************************************************************/
   /*  Error code generated by generic software?                           */
   /************************************************************************/

   switch (error_code)
    {
      case SEL_SEN_NOT_FOUND:
        sprintf (e_str, "SELECT_SENSOR: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
 
      case LOCATE_NOT_FOUND:
        sprintf (e_str, "LOCATE_EX: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;

      case LOCATE_EX_MALLOC:
        sprintf (e_str, "LOCATE_EX: NO MEMORY FOR EX_INFO.");
        break;

      case LOCATE_PTR_MALLOC:
        sprintf (e_str, "LOCATE_EX: NO MEMORY FOR PTR_REC INFO.");
        break;

      case LOCATE_EX_REALLOC:
        sprintf (e_str, "LOCATE_EX: NO MEMORY FOR EX_INFO EXPANSION.");
        break;
  
      case PBACK_BAD_SRC:
        sprintf (e_str, "PLAYBACK_DATA_FILES: ERROR DECODING THE DATA KEY.");
        break;
    
      case PBACK_NO_HEADER:
        ex = ginfo.expt;
        sprintf (e_str, "PLAYBACK_DATA_FILES: ERROR OPENING THE HEADER FILE %s.", ex->header_name);
        break;
    
      case PBACK_NO_DATA:
        ex = ginfo.expt;
        sprintf (e_str, "PLAYBACK_DATA_FILES: ERROR OPENING THE DATA FILE %s.", ex->data_name);
        break;
    
      case PBACK_NO_VIDF:
        ex = ginfo.expt;
        sprintf (e_str, "PLAYBACK_DATA_FILES: ERROR OPENING THE VIDF FILE %s.", ex->idf_name);
        break;
    
      case RTIME_BAD_SRC:
        sprintf (e_str, "REALTIME_DATA_FILES: ERROR DECODING THE DATA KEY.");
        break;
    
      case RTIME_NO_HEADER:
        ex = ginfo.expt;
        sprintf (e_str, "REALTIME_DATA_FILES: ERROR OPENING THE HEADER FILE %s.", ex->header_name);
        break;
    
      case RTIME_NO_DATA:
        ex = ginfo.expt;
        sprintf (e_str, "REALTIME_DATA_FILES: ERROR OPENING THE DATA FILE %s.", ex->data_name);
        break;
    
      case RTIME_NO_VIDF:
        ex = ginfo.expt;
        sprintf (e_str, "REALTIME_DATA_FILES: ERROR OPENING THE VIDF FILE %s.", ex->idf_name);
        break;
    
      case ALLOC_HDR_READ_ERROR:
        sprintf (e_str, "ALLOC_EXP_ONCE: READ ERROR ON HEADER FILE.");
        break;

      case ALLOC_HDR_MALLOC:
        sprintf (e_str, "ALLOC_EXP_ONCE: NO MEMORY FOR HEADER INFORMATION.");
        break;
    
      case ALLOC_HDR_REALLOC:
        sprintf (e_str, "ALLOC_EXP_ONCE: NO MEMORY FOR EXPANSION OF HEADER INFORMATION.");
        break;
     
      case TIME_OFF_MALLOC:
        sprintf (e_str, "ALLOC_EXP_ONCE: NO MEMORY FOR SENSOR TIME OFFSET VALUES.");
        break;

      case EXP_IDF_MANY_BYTES:
        sprintf (e_str, "ALLOC_EXP_ONCE: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;

      case EXP_IDF_NOT_FOUND:
        sprintf (e_str, "ALLOC_EXP_ONCE: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;

      case EXP_IDF_TBL_NUM:
        sprintf (e_str, "ALLOC_EXP_ONCE: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;

      case EXP_IDF_CON_NUM:
        sprintf (e_str, "ALLOC_EXP_ONCE: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;

      case EXP_IDF_NO_ENTRY:
        sprintf (e_str, "ALLOC_EXP_ONCE: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
 
      case RHDR_READ_ERROR:
        sprintf (e_str, "READ_HEADER: READ ERROR ON HEADER FILE.");
        break;
   
      case RHDR_HDR_MALLOC:
        sprintf (e_str, "READ_HEADER: NO MEMORY FOR HEADER INFORMATION.");
        break;
     
      case RHDR_HDR_REALLOC:
        sprintf (e_str, "READ_HEADER: NO MEMORY FOR EXPANSION OF HEADER INFORMATION.");
        break;
      
      case ALL_FLAG_MALLOC:
        sprintf (e_str, "FILE_SETUP: NO MEMORY FOR SENSOR FLAGS.");
        break;
  
      case OPEN_EX_MALLOC:
        sprintf (e_str, "FILE_SETUP: NO MEMORY FOR EX_INFO.");
        break;

      case OPEN_PTR_MALLOC:
        sprintf (e_str, "FILE_SETUP: NO MEMORY FOR PTR_REC INFO.");
        break;
   
      case OPEN_EX_REALLOC:
        sprintf (e_str, "FILE_SETUP: NO MEMORY FOR EX_INFO EXPANSION.");
        break;
   
      case POS_NOT_FOUND:
        sprintf (e_str, "FILE_POS: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case FILE_POS_MODE:
        sprintf (e_str, "FILE_POS: ERROR PROCESSING MODE DEPENDENT INFORMATION.");
        break;
   
      case FILE_POS_PA:
        sprintf (e_str, "FILE_POS: ERROR PROCESSING PITCH ANGLE INFORMATION.");
        break;
   
      case POS_DATA_READ_ERROR:
        sprintf (e_str, "FILE_POS: READ ERROR ON DATA FILE.");
        break;
   
      case POS_HDR_READ_ERROR:
        sprintf (e_str, "FILE_POS: READ ERROR ON HEADER FILE.");
        break;

      case POS_HDR_MALLOC:
        sprintf (e_str, "FILE_POS: NO MEMORY FOR HEADER INFORMATION.");
        break;
       
      case POS_HDR_REALLOC:
        sprintf (e_str, "FILE_POS: NO MEMORY FOR EXPANSION OF HEADER INFORMATION.");
        break;
       
      case CAL_DATA_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR CAL DATA INFORMATION.");
        break;
      
      case ONCE_DATA_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR DATA RECORD INFORMATION.");
        break;
      
      case ONCE_D_TYPE_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR D_TYPE FOR EACH SENSOR.");
        break;
   
      case ONCE_TDW_LEN_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR TDW_LEN FOR EACH SENSOR.");
        break;
   
      case ONCE_TYPE_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR TBL_TYPE VALUES.");
        break;
   
      case ONCE_VAR_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR TBL_VAR VALUES.");
        break;
   
      case ONCE_EXPAND_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR TBL_EXPAND VALUES.");
        break;
   
      case ONCE_SEN_STAT_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR SENSOR STATUS FLAGS.");
        break;
   
      case ONCE_CTARGET_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR CAL. SET TARGET VALUES.");
        break;
   
      case ONCE_CLEN_MALLOC:
        sprintf (e_str, "READ_IDF_ONCE: NO MEMORY FOR CAL. SET WORD LENGTHS.");
        break;
   
      case ONCE_IDF_MANY_BYTES:
        sprintf (e_str, "READ_IDF_ONCE: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case ONCE_IDF_NOT_FOUND:
        sprintf (e_str, "READ_IDF_ONCE: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case ONCE_IDF_TBL_NUM:
        sprintf (e_str, "READ_IDF_ONCE: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case ONCE_IDF_CON_NUM:
        sprintf (e_str, "READ_IDF_ONCE: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;

      case ONCE_IDF_NO_ENTRY:
        sprintf (e_str, "READ_IDF_ONCE: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;

      case ASCII_AFTER_SENSOR:
        sprintf (e_str, "READ_IDF_ONCE: ALL ASCII AND/OR MODE-DEPENDENT TABLES MUST BE DEFINED AFTER ALL OTHER TABLES.");
        break;

      case DREC_NOT_FOUND:
        sprintf (e_str, "READ_DREC: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case DREC_NO_FILES:
        sprintf(e_str, "READ_DREC: ATTEMPTED READ ON UNOPENED FILES.");
        break;
       
      case DREC_READ_ERROR:
        sprintf (e_str, "NEW_DATA_RECORD: READ ERROR ON DATA FILE.");
        break;
      
      case DREC_HDR_READ_ERROR:
        sprintf (e_str, "NEW_HEADER_RECORD: READ ERROR ON HEADER FILE.");
        break;
  
      case DREC_HDR_MALLOC:
        sprintf (e_str, "NEW_HEADER_RECORD: NO MEMORY FOR HEADER INFORMATION.");
        break;
       
      case DREC_HDR_REALLOC:
        sprintf (e_str, "NEW_HEADER_RECORD: NO MEMORY FOR EXPANSION OF HEADER INFORMATION.");
        break;
       
      case SEN_IDF_MANY_BYTES:
        sprintf (e_str, "GET_SENSOR_TABLES: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;

      case SEN_IDF_NOT_FOUND:
        sprintf (e_str, "GET_SENSOR_TABLES: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case SEN_IDF_TBL_NUM:
        sprintf (e_str, "GET_SENSOR_TABLES: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case SEN_IDF_CON_NUM:
        sprintf (e_str, "GET_SENSOR_TABLES: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;

      case SEN_IDF_NO_ENTRY:
        sprintf (e_str, "GET_SENSOR_TABLES: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;

      case SCOM_TBL_MALLOC:
        sprintf (e_str, "SENSOR_COMBO: NO MEMORY FOR TABLE OFFSET VALUES.");
        break;
       
      case SCOM_INDEX_MALLOC:
        sprintf (e_str, "SENSOR_COMBO: NO MEMORY FOR COMBINATION INDEX VALUES FOR THE SENSORS.");
        break;
       
      case SCOM_SEN_PTR_MALLOC:
        sprintf (e_str, "SENSOR_COMBO: NO MEMORY FOR SENSOR COMBINATION STRUCTURES.");
        break;
       
      case SCOM_PTR_MALLOC:
        sprintf (e_str, "SENSOR_COMBO: NO MEMORY FOR ARRAY OF POINTERS TO THE TABLE OFFSET VALUES.");
        break;
       
      case SCOM_IDF_MANY_BYTES:
        sprintf (e_str, "SENSOR_COMBO: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
  
      case SCOM_IDF_NOT_FOUND:
        sprintf (e_str, "SENSOR_COMBO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case SCOM_IDF_TBL_NUM:
        sprintf (e_str, "SENSOR_COMBO: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;

      case SCOM_IDF_CON_NUM:
        sprintf (e_str, "SENSOR_COMBO: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case SCOM_IDF_NO_ENTRY:
        sprintf (e_str, "SENSOR_COMBO: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case GET_ACTION_MALLOC:
        sprintf (e_str, "GET_CRITICAL_INFO: NO MEMORY FOR CRITICAL STATUS ACTION ARRAY.");
        break;
       
      case CRIT_IDF_MANY_BYTES:
        sprintf (e_str, "GET_CRITICAL_INFO: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case CRIT_IDF_NOT_FOUND:
        sprintf (e_str, "GET_CRITICAL_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case CRIT_IDF_TBL_NUM:
        sprintf (e_str, "GET_CRITICAL_INFO: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case CRIT_IDF_CON_NUM:
        sprintf (e_str, "GET_CRITICAL_INFO: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case CRIT_IDF_NO_ENTRY:
        sprintf (e_str, "GET_CRITICAL_INFO: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case CCOM_MATCH_MALLOC:
        sprintf (e_str, "COUNT_COMBO: NO MEMORY FOR THE NO_MATCH ARRAY.");
        break;

      case CCOM_VAL_MALLOC:
        sprintf (e_str, "COUNT_COMBO: NO MEMORY FOR THE TABLE OFFSET VALUES BEING COMPARED.");
        break;
   
      case READ_IN_MALLOC:
        sprintf (e_str, "READ_IN_TBL: NO MEMORY FOR TABLE BEING READ IN FROM VIDF FILE.");
        break;
       
      case READ_IN_IDF_MANY_BYTES:
        sprintf (e_str, "READ_IN_TBL: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;

      case READ_IN_IDF_NOT_FOUND:
        sprintf (e_str, "READ_IN_TBL: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case READ_IN_IDF_TBL_NUM:
        sprintf (e_str, "READ_IN_TBL: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case READ_IN_IDF_CON_NUM:
        sprintf (e_str, "READ_IN_TBL: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;

      case READ_IN_IDF_NO_ENTRY:
        sprintf (e_str, "READ_IN_TBL: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;

      case TBL_MISC_MALLOC:
        sprintf (e_str, "GET_TBL_INFO: NO MEMORY TO HOLD TABLE INFORMATION FOR ALL TELEMETRY TABLES.");
        break;
   
      case TBL_MALLOC:
        sprintf (e_str, "GET_TBL_INFO: NO MEMORY TO HOLD VALUES FOR ALL TELEMETRY TABLES.");
        break;
   
      case TBL_IDF_MANY_BYTES:
        sprintf (e_str, "GET_TBL_INFO: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case TBL_IDF_NOT_FOUND:
        sprintf (e_str, "GET_TBL_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
       
      case TBL_IDF_TBL_NUM:
        sprintf (e_str, "GET_TBL_INFO: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case TBL_IDF_CON_NUM:
        sprintf (e_str, "GET_TBL_INFO: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case TBL_IDF_NO_ENTRY:
        sprintf (e_str, "GET_TBL_INFO: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case TBL_VAR_NOT_CAL:
        sprintf (e_str, "GET_TBL_INFO: FOR TBL_TYPE 2, TBL_VAR CAN ONLY BE A FN. OF CAL SETS WHEN TBL_FMT EQUALS ZERO.");
        break;
   
      case TBL_VAR_NOT_RAW:
        sprintf (e_str, "GET_TBL_INFO: FOR TBL_TYPE 0, TBL_VAR CAN NOT BE PROCESSED DATA WHEN TBL_FMT EQUALS ZERO.");
        break;
   
      case CRIT_TBL_NOT_FOUND:
        sprintf (e_str, "CHECK_CRITICAL_STATUS: THE TABLE REQUESTED WAS NOT FOUND AMONGST SENSOR TABLES.");
        break;
    
      case IDF_MANY_BYTES:
        sprintf (e_str, "READ_IDF: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case IDF_NOT_FOUND:
        sprintf (e_str, "READ_IDF: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case IDF_TBL_NUM:
        sprintf (e_str, "READ_IDF: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case IDF_CON_NUM:
        sprintf (e_str, "READ_IDF: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case IDF_NO_ENTRY:
        sprintf (e_str, "READ_IDF: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case ALLOC_EV_MALLOC:
        sprintf (e_str, "ALLOC_SWP_DATA: NO MEMORY FOR EV ARRAY.");
        break;
   
      case ALLOC_EV_REALLOC:
        sprintf (e_str, "ALLOC_SWP_DATA: NO MEMORY FOR EXPANSION OF EV ARRAY.");
        break;
   
      case RESET_CSET_MALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR CAL. SET SIZE ARRAY.");
        break;

      case RESET_DATA_MALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR DATA ARRAY.");
        break;

      case RESET_DATA_REALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR EXPANSION OF DATA ARRAY.");
        break;
   
      case RESET_ANGLE_MALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR AZIMUTHAL ANGLE ARRAY.");
        break;

      case RESET_ANGLE_REALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR EXPANSION OF AZIMUTHAL ANGLE ARRAY.");
        break;
   
      case RESET_PITCH_MALLOC:
        sprintf (e_str, "CHECK_DEPENDENT_ON_HEADER: NO MEMORY FOR PITCH ANGLE ARRAY.");
        break;

      case RESET_PITCH_REALLOC:
        sprintf (e_str, "CHECK_DEPENDENT_ON_HEADER: NO MEMORY FOR EXPANSION OF PITCH ANGLE ARRAY.");
        break;
   
      case RESET_MODE_MALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR MODE INFORMATION.");
        break;
  
      case RESET_MODE_REALLOC:
        sprintf (e_str, "RESET_HEADER: NO MEMORY FOR EXPANSION OF MODE INFORMATION.");
        break;
  
      case RESET_NOT_FOUND:
        sprintf (e_str, "RESET_EXPERIMENT_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case FILL_HEADER:
        sprintf (e_str, "READ_HEADER: BAD HEADER RECORD READ FROM FILE - RE-RETRIEVE HEADER FILE FROM DATABASE.");
        break;
   
      case PARTIAL_READ:
        sprintf (e_str, "THE NO. OF BYTES READ DID NOT MATCH THE NUMBER OF BYTES REQUESTED FOR HEADER OR DATA FILE.");
        break;
   
      case CNVT_BAD_DTYPE:
        sprintf (e_str, "CONVERT_TO_UNITS: THE DATA TYPE REQUESTED IS NOT SUPPORTED BY THIS ROUTINE.");
        break;
   
      case CNVT_NOT_FOUND:
        sprintf (e_str, "CONVERT_TO_UNITS: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case CNVT_BAD_TBL_OPER:
        sprintf (e_str, "CONVERT_TO_UNITS: THERE IS NO LOOK-UP OPERATION DEFINED (OPER = 2000).");
        break;
   
      case CNVT_NO_TMP:
        sprintf (e_str, "CONVERT_TO_UNITS: NO DATA WILL BE PLACED IN INTERMEDIATE BUFFERS TO ADD TO PERMANENT BUFFERS.");
        break;
   
      case CNVT_TMP_MALLOC:
        sprintf (e_str, "CONVERT_TO_UNITS: NO MEMORY FOR THE INTERMEDIATE BUFFER SPACE.");
        break;
   
      case CNVT_BAD_TBL_NUM:
        sprintf (e_str, "CONVERT_TO_UNITS: INVALID TABLE NUMBER.");
        break;
 
      case CREATE_TBL_MALLOC:
        sprintf (e_str, "CREATE_TBL: NO MEMORY FOR TABLE BEING CONSTRUCTED.");
        break;
   
      case CREATE_IDF_MANY_BYTES:
        sprintf (e_str, "CREATE_TBL: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case CREATE_IDF_NOT_FOUND:
        sprintf (e_str, "CREATE_TBL: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case CREATE_IDF_TBL_NUM:
        sprintf (e_str, "CREATE_TBL: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case CREATE_IDF_CON_NUM:
        sprintf (e_str, "CREATE_TBL: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case CREATE_IDF_NO_ENTRY:
        sprintf (e_str, "CREATE_TBL: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case NEW_IDF_MANY_BYTES:
        sprintf (e_str, "GET_NEW_TBL: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case NEW_IDF_NOT_FOUND:
        sprintf (e_str, "GET_NEW_TBL: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case NEW_IDF_TBL_NUM:
        sprintf (e_str, "GET_NEW_TBL: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case NEW_IDF_CON_NUM:
        sprintf (e_str, "GET_NEW_TBL: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;

      case NEW_IDF_NO_ENTRY:
        sprintf (e_str, "GET_NEW_TBL: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;

      case NEW_SCALE_MALLOC:
        sprintf (e_str, "GET_NEW_TBL: NO MEMORY FOR TABLE SCALING VALUES.");
        break;
   
      case CONST_ANG_MALLOC:
        sprintf (e_str, "GET_CONSTANTS: NO MEMORY FOR ANGLE CONSTANT VALUES.");
        break;
   
      case CONST_TEMP_MALLOC:
        sprintf (e_str, "GET_CONSTANTS: NO MEMORY FOR TEMPORARY WORKING SPACE.");
        break;
   
      case CONST_IDF_MANY_BYTES:
        sprintf (e_str, "GET_CONSTANTS: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case CONST_IDF_NOT_FOUND:
        sprintf (e_str, "GET_CONSTANTS: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case CONST_IDF_TBL_NUM:
        sprintf (e_str, "GET_CONSTANTS: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case CONST_IDF_CON_NUM:
        sprintf (e_str, "GET_CONSTANTS: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case CONST_IDF_NO_ENTRY:
        sprintf (e_str, "GET_CONSTANTS: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case FILL_SEN_MODE_TYPE:
        sprintf (e_str, "FILL_SENSOR_INFO: MODE DATA IS NOT SUPPORTED BY THIS FUNCTION.");
        break;
 
      case FILL_SEN_NOT_FOUND:
        sprintf (e_str, "FILL_SENSOR_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case FILL_SEN_MALLOC:
        sprintf (e_str, "FILL_SENSOR_INFO: NO MEMORY FOR ARRAY OF FILL_SENSOR STRUCTURES.");
        break;
   
      case FILL_SEN_REALLOC:
        sprintf (e_str, "FILL_SENSOR_INFO: NO MEMORY FOR EXPANSION OF FILL_SENSOR STRUCTURES.");
        break;
   
      case FILL_SEN_BASE_MALLOC:
        sprintf (e_str, "FILL_SENSOR_INFO: NO MEMORY FOR ARRAY OF MIN_MAX_TBL_APP STRUCTURES.");
        break;
   
      case FILL_SEN_BASE_REALLOC:
        sprintf (e_str, "FILL_SENSOR_INFO: NO MEMORY FOR EXPANSION OF MIN_MAX_TBL_APP STRUCTURES.");
        break;
   
      case FILL_SEN_TBL_MALLOC:
        sprintf (e_str, "FILL_SENSOR_INFO: NO MEMORY FOR TABLE APPLICATION FLAGS.");
        break;
  
      case NO_EMPTY_BUFFERS:
        sprintf (e_str, "FILL_DATA: NO SPARE DATA BUFFERS.");
        break;
  
      case FILL_WITH_SWEEP:
        sprintf (e_str, "FILL_DATA: SWEEP_DATA AND FILL_DATA CANNOT BE CALLED IN CONJUNCTION.");
        break;
  
      case FILL_NOT_FOUND:
        sprintf (e_str, "FILL_DATA: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case FILL_BASE_TIME_MISSING:
        sprintf (e_str, "FILL_DATA: THE ROUTINE SET_TIME_VALUES HAS NOT BEEN CALLED PRIOR TO CALLING THE FILL_DATA ROUTINE.");
        break;
  
      case FILL_BIN_MISSING:
        sprintf (e_str, "FILL_DATA: THE ROUTINE SET_BIN_INFO HAS NOT BEEN CALLED PRIOR TO CALLING THE FILL_DATA ROUTINE.");
        break;
  
      case UNITS_IND_MODE_TYPE:
        sprintf (e_str, "UNITS_INDEX: MODE DATA IS NOT SUPPORTED BY THIS FUNCTION.");
        break;
 
      case UNITS_IND_NOT_FOUND:
        sprintf (e_str, "UNITS_INDEX: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case UNITS_NO_SENSOR:
        sprintf (e_str, "UNITS_INDEX: REQUESTED SENSOR NOT FOUND AMONGST FILL INFORMATION.");
        break;
  
      case UNITS_NO_MATCH:
        sprintf (e_str, "UNITS_INDEX: REQUESTED DATA LEVEL NOT FOUND.");
        break;
  
      case FILL_INFO_MALLOC:
        sprintf (e_str, "ALLOC_FILL_INFO: NO MEMORY FOR DATA BUFFER INFORMATION.");
        break;
   
      case FILL_ARRAY_MALLOC:
        sprintf (e_str, "ALLOC_FILL_ARRAYS: NO MEMORY FOR FILL_DATA STRUCTURE.");
        break;
   
      case FILL_DATA_MALLOC:
        sprintf (e_str, "ALLOC_FILL_DATA: NO MEMORY FOR DATA BUFFERS.");
        break;
   
      case FILL_SWP_MALLOC:
        sprintf (e_str, "ALLOC_FILL_DATA: NO MEMORY FOR CONVERTED SWEEP VALUES.");
        break;
   
      case FILL_SWP_REALLOC:
        sprintf (e_str, "ALLOC_FILL_DATA: NO MEMORY FOR EXPANSION OF CONVERTED SWEEP VALUES.");
        break;
   
      case FILL_UNITS_MALLOC:
        sprintf (e_str, "ALLOC_FILL_DATA: NO MEMORY FOR CONVERTED UNITS PER BUFFER.");
        break;
   
      case FILL_UNITS_REALLOC:
        sprintf (e_str, "ALLOC_FILL_DATA: NO MEMORY FOR EXPANSION OF CONVERTED UNITS PER BUFFER.");
        break;
   
      case COLLAPSE_NOT_FOUND:
        sprintf (e_str, "SET_COLLAPSE_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case COLLAPSE_MALLOC:
        sprintf (e_str, "SET_COLLAPSE_INFO: NO MEMORY FOR COLLAPSE_DATA STRUCTURE.");
        break;
   
      case COLLAPSE_SEN_MALLOC:
        sprintf (e_str, "SET_COLLAPSE_INFO: NO MEMORY FOR SENSOR SPECIFIC ARRAYS.");
        break;
   
      case THETA_CHK_MALLOC:
        sprintf (e_str, "CALC_THETA_BINS: NO MEMORY FOR TEMPORARY ARRAY.");
        break;

      case THETA_BIN_MALLOC:
        sprintf (e_str, "CALC_THETA_BINS: NO MEMORY FOR THETA ANGLE VALUES.");
        break;
   
      case ORDER_THETA_MALLOC:
        sprintf (e_str, "ORDER_THETA_BINS: NO MEMORY FOR THETA ORDER INDEXES.");
        break;
   
      case COLLAPSE_DATA_MALLOC:
        sprintf (e_str, "ALLOC_COLLAPSE_DATA: NO MEMORY FOR COLLAPSING DATA ARRAYS.");
        break;
   
      case PHI_DIFF_UNITS:
        sprintf (e_str, "FILL_PHI_BINS: SENSORS DO NOT PROCESS THE SAME NUMBER OF DATA LEVELS.");
        break;
   
      case FILL_PHI_FIRST:
        sprintf (e_str, "FILL_PHI_BINS: THE STARTING AZIMUTHAL ANGLE WAS NOT CONTAINED WITHIN ANY OF THE DEFINED PHI BINS.");
        break;
   
      case FILL_PHI_LAST:
        sprintf (e_str, "FILL_PHI_BINS: THE ENDING AZIMUTHAL ANGLE WAS NOT CONTAINED WITHIN ANY OF THE DEFINED PHI BINS.");
        break;
   
      case FILL_THETA_NOT_FOUND:
        sprintf (e_str, "FILL_THETA_MATRIX: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case THETA_DIFF_UNITS:
        sprintf (e_str, "FILL_THETA_MATRIX : SENSORS DO NOT PROCESS THE SAME NUMBER OF DATA LEVELS.");
        break;

      case FILL_THETA_COLLAPSE:
        sprintf (e_str, "FILL_THETA_MATRIX : NO MEMORY HAS BEEN ALLOCATED FOR COLLAPSING DATA.");
        break;
   
      case CDIMEN_NOT_FOUND:
        sprintf (e_str, "COLLAPSE_DIMENSIONS: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case CDIMEN_MANY_SCAN:
        sprintf (e_str, "COLLAPSE_DIMENSIONS: MORE THAN ONE SCAN RANGE WAS REQUESTED FOR THIS VIRTUAL INSTRUMENT.");
        break;
   
      case CENTER_NOT_FOUND:
        sprintf (e_str, "CENTER_AND_BAND_VALUES: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case CDIMEN_COLLAPSE:
        sprintf (e_str, "COLLAPSE_DIMENSIONS : NO MEMORY HAS BEEN ALLOCATED FOR COLLAPSING DATA.");
        break;
   
      case BPTR_NOT_FOUND:
        sprintf (e_str, "CENTER_AND_BAND_VALUES: THE BIN_INFO STRUCTURE HAS NEVER BEEN ALLOCATED.");
        break;
  
      case CENTER_NO_SENSOR:
        sprintf (e_str, "CENTER_AND_BAND_VALUES: THE SPECIFIED SENSOR IS NOT FLAGGED AS A SENSOR THAT IS BEING PROCESSED.");
        break;
  
      case CENTER_TMP_MALLOC:
        sprintf (e_str, "CENTER_AND_BAND_VALUES: NO MEMORY FOR TEMPORARY SCRATCH SPACE.");
        break;
  
      case SET_BIN_NOT_FOUND:
        sprintf (e_str, "SET_BIN_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case SET_BIN_BAD_FMT:
        sprintf (e_str, "SET_BIN_INFO: ZERO OR VARIABLE WIDTH SPACING CAN ONLY BE REQUESTED IN CONJUNCTION WITH FIXED SWEEP PROCESSING.");
        break;
  
      case SET_BIN_MALLOC:
        sprintf (e_str, "SET_BIN_INFO: NO MEMORY FOR BIN_INFO STRUCTURE.");
        break;
  
      case SET_BIN_INDEX_MALLOC:
        sprintf (e_str, "SET_BIN_INFO: NO MEMORY FOR INDEX VALUES FOR THE SENSORS.");
        break;
       
      case SET_VWIDTH_CENTER_MALLOC:
        sprintf (e_str, "SET_VWIDTH_INFO: NO MEMORY FOR VARIABLE WIDTH CENTER TBLS/OPERS.");
        break;
  
      case SET_VWIDTH_BAND_MALLOC:
        sprintf (e_str, "SET_VWIDTH_INFO: NO MEMORY FOR VARIABLE WIDTH BAND TBLS/OPERS.");
        break;
  
      case BAND_MALLOC:
        sprintf (e_str, "CENTER_AND_BAND_VALUES: NO MEMORY FOR SWEEP BAND VALUES.");
        break;
  
      case CENTER_MALLOC:
        sprintf (e_str, "CENTER_AND_BAND_VALUES: NO MEMORY FOR CENTER SWEEP VALUES.");
        break;
  
      case PBACK_LOS:
        sprintf (e_str, "FILE_POS : An LOS indicator record was encountered while trying to find the start time record.");
        break;
  
      case PBACK_NEXT_FILE:
        sprintf (e_str, "FILE_POS : A NEXT_FILE indicator record was encountered while trying to find the start time record.");
        break;

      case NUM_CAL_MALLOC:
        sprintf (e_str, "NUMBER_OF_CAL_ELEMENTS: NO MEMORY FOR ARRAY THAT HOLDS RETURNED CAL. VALUES.");
        break;
      
      case NUM_CAL_REALLOC:
        sprintf (e_str, "NUMBER_OF_CAL_ELEMENTS: NO MEMORY FOR EXPANSION OF ARRAY THAT HOLDS RETURNED CAL. VALUES.");
        break;
  
      case TIMING_MALLOC:
        sprintf (e_str, "ALLOC_TIMING : NO MEMORY HAS BEEN ALLOCATED FOR PIXEL TIMING INFO.");
        break;
   
      case RET_PHI_NOT_FOUND:
        sprintf (e_str, "RETURN_PHI_PTRS: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case CPTR_RET_PHI:
        sprintf (e_str, "RETURN_PHI_PTRS : NO MEMORY HAS BEEN ALLOCATED FOR COLLAPSING DATA.");
        break;
   
      case NO_RET_PHI:
        sprintf (e_str, "RETURN_PHI_PTRS : NO MEMORY HAS BEEN ALLOCATED FOR PHI PROCESSING.");
        break;
   
      case BUF_BIN_MALLOC:
        sprintf (e_str, "BUFFER_BIN_FILL: NO MEMORY FOR BIN_STAT TEMPORARY ARRAY.");
        break;
   
      case BUF_BIN_NOT_FOUND:
        sprintf (e_str, "BUFFER_BIN_FILL: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case IMAGE_NOT_FOUND:
        sprintf (e_str, "START_IMAGE: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case IMAGE_READ_ERROR:
        sprintf (e_str, "START_IMAGE: READ ERROR ON DATA OR HEADER FILE.");
        break;
   
      case IMAGE_HDR_MALLOC:
        sprintf (e_str, "START_IMAGE: NO MEMORY FOR HEADER INFORMATION.");
        break;
       
      case IMAGE_HDR_REALLOC:
        sprintf (e_str, "START_IMAGE: NO MEMORY FOR EXPANSION OF HEADER INFORMATION.");
        break;
       
      case CALC_CENTER_DREC:
        sprintf (e_str, "CALC_CENTER_SWEEP: READ_DREC ERROR WAS ENCOUNTERED.");
        break;
       
      case BAD_VFMT:
        sprintf (e_str, "CALC_BAND_WIDTHS: BAD FORMAT CHARACTER FOR VARIABLE WIDTH PROCESSING.");
        break;
       
      case DKEY_PROJECT:
        sprintf (e_str, "GET_DATA_KEY: INVALID PROJECT NAME PASSED AS ARGUMENT.");
        break;
       
      case DKEY_MISSION:
        sprintf (e_str, "GET_DATA_KEY: INVALID MISSION NAME PASSED AS ARGUMENT.");
        break;
       
      case DKEY_EXPERIMENT:
        sprintf (e_str, "GET_DATA_KEY: INVALID EXPERIMENT NAME PASSED AS ARGUMENT.");
        break;
       
      case DKEY_INSTRUMENT:
        sprintf (e_str, "GET_DATA_KEY: INVALID INSTRUMENT NAME PASSED AS ARGUMENT.");
        break;
       
      case DKEY_VINST:
        sprintf (e_str, "GET_DATA_KEY: INVALID VIRTUAL INSTRUMENT NAME PASSED AS ARGUMENT.");
        break;
       
      case CALC_TRES_NOT_FOUND:
        sprintf (e_str, "CALC_TIME_RESOLUTION: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case CONV_CAL_MALLOC:
        sprintf (e_str, "CONVERT_CAL_DATA: MALLOC ERROR FOR TEMPORARY DATA ARRAY.");
        break;
  
      case CONV_CAL_VECTOR_MISMATCH:
        sprintf (e_str, "CONVERT_CAL_DATA: THE CALIBRATION DATA USES A TABLE THAT IS NOT DIMENSIONED THE SAME SIZE.");
        break;
  
      case INIT_VIDF_NOT_FOUND:
        sprintf (e_str, "INIT_VIDF: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case INIT_VIDF_BAD_VERSION:
        sprintf (e_str, "INIT_VIDF: BAD VERSION NUMBER FOR THE VIDF FILE.");
        break;
  
      case INIT_VIDF_TBL_MALLOC:
        sprintf (e_str, "INIT_VIDF: NO MEMORY FOR TABLES.");
        break;
  
      case INIT_VIDF_CONST_MALLOC:
        sprintf (e_str, "INIT_VIDF: NO MEMORY FOR CONSTANTS.");
        break;
  
      case SET_SCAN_NOT_FOUND:
        sprintf (e_str, "SET_SCAN_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case SCAN_BIN_MISSING:
        sprintf (e_str, "SET_SCAN_INFO: THE ROUTINE SET_BIN_INFO HAS NOT BEEN CALLED PRIOR TO CALLING THIS ROUTINE.");
        break;
  
      case SET_SCAN_TBL_MALLOC:
        sprintf (e_str, "SET_SCAN_INFO: NO MEMORY FOR SWEEP STEP TABLE APPLICATION FLAGS.");
        break;
  
       case SCAN_INDEX_MALLOC:
         sprintf (e_str, "SET_SCAN_INFO: NO MEMORY FOR INDEX VALUES FOR THE SENSORS.");
         break;
       
       case SCAN_IDF_MANY_BYTES:
         sprintf (e_str, "SET_SCAN_INFO: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
         break;

       case SCAN_IDF_NOT_FOUND:
         sprintf (e_str, "SET_SCAN_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
         break;
   
       case SCAN_IDF_TBL_NUM:
         sprintf (e_str, "SET_SCAN_INFO: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
         break;
   
       case SCAN_IDF_CON_NUM:
         sprintf (e_str, "SET_SCAN_INFO: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
         break;

       case SCAN_IDF_NO_ENTRY:
         sprintf (e_str, "SET_SCAN_INFO: THE FIELD BEING REQUESTED IS NOT DEFINED.");
         break;

      case CONV_MODE_BAD_TBL_NUM:
        sprintf (e_str, "CONVERT_MODE_DATA: TABLE NUMBER NOT FOUND AMONGST TABLES DEFINED FOR THE MODE IN QUESTION.");
        break;

      case CONV_MODE_BAD_MODE:
        sprintf (e_str, "CONVERT_MODE_DATA: INVALID MODE NUMBER.");
        break;

      case CONV_MODE_MISMATCH:
        sprintf (e_str, "CONVERT_MODE_DATA: ONLY TABLES THAT APPLY TO RAW OR PROCESSED MODE DATA IS VALID.");
        break;

      case FILL_DISC_NOT_FOUND:
        sprintf (e_str, "FILL_DISCONTINUOUS_DATA: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case FILL_DISC_BASE_TIME_MISSING:
        sprintf (e_str, "FILL_DISCONTINUOUS_DATA: THE ROUTINE SET_TIME_VALUES HAS NOT BEEN CALLED PRIOR TO CALLING THE FILL_DISCONTINUOUS_DATA ROUTINE.");
        break;
  
      case FILL_DISC_BIN_MISSING:
        sprintf (e_str, "FILL_DISCONTINUOUS_DATA: THE ROUTINE SET_BIN_INFO HAS NOT BEEN CALLED PRIOR TO CALLING THE FILL_DISCONTINUOUS_DATA ROUTINE.");
        break;
  
      case FILL_DISC_NO_PHI:
        sprintf (e_str, "FILL_DISCONTINUOUS_DATA: THE FILL_DISCONTINUOUS_DATA ROUTINE DOES NOT HANDLE DATA WITH DIMENSIONS HIGHER THAN THETA.");
        break;
  
      case FILL_WITH_SWEEP_DISC:
        sprintf (e_str, "FILL_DISCONTINUOUS_DATA: SWEEP_DISCONTINUOUS_DATA AND FILL_DISCONTINUOUS_DATA CANNOT BE CALLED IN CONJUNCTION.");
        break;
  
      case FILL_DISC_MALLOC:
        sprintf (e_str, "ALLOC_FILL_DISCONTINUOUS: NO MEMORY FOR FILL_DISCONTINUOUS STRUCTURE.");
        break;
   
      case DISC_DATA_MALLOC:
        sprintf (e_str, "ALLOC_DISCONTINUOUS_DATA: NO MEMORY FOR DATA BUFFERS.");
        break;
   
      case DISC_TMP_MALLOC:
        sprintf (e_str, "TRANSFER_DISC_DATA: NO MEMORY FOR TEMPORARY SCRATCH SPACE.");
        break;
  
      case MODE_PTR_MALLOC:
        sprintf (e_str, "GET_MODE_INFO: NO MEMORY FOR MODE TABLE STRUCTURES.");
        break;
  
      case MODE_TBL_MISC_MALLOC:
        sprintf (e_str, "GET_MODE_TBL: NO MEMORY TO HOLD INFORMATION FOR ALL INTEGER MODE TABLES.");
        break;
   
      case MODE_TBL_IDF_MANY_BYTES:
        sprintf (e_str, "GET_MODE_TBL: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case MODE_TBL_IDF_NOT_FOUND:
        sprintf (e_str, "GET_MODE_TBL: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
       
      case MODE_TBL_IDF_TBL_NUM:
        sprintf (e_str, "GET_MODE_TBL: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case MODE_TBL_IDF_CON_NUM:
        sprintf (e_str, "GET_MODE_TBL: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case MODE_TBL_IDF_NO_ENTRY:
        sprintf (e_str, "GET_MODE_TBL: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
   
      case MODE_TBL_VAR_NOT_CAL:
        sprintf (e_str, "GET_MODE_TBL: FOR TBL_TYPE 2, TBL_VAR CAN ONLY BE A FN. OF CAL SETS WHEN TBL_FMT EQUALS ZERO.");
        break;
   
      case MODE_TBL_VAR_NOT_RAW:
        sprintf (e_str, "GET_MODE_TBL: FOR TBL_TYPE 0, TBL_VAR CAN NOT BE PROCESSED DATA WHEN TBL_FMT EQUALS ZERO.");
        break;
   
      case MODE_TBL_MALLOC:
        sprintf (e_str, "GET_MODE_TBL: NO MEMORY TO HOLD VALUES FOR ALL TELEMETRY TABLES.");
        break;
   
      case MODE_TBL_SZ_IDF_MANY_BYTES:
        sprintf (e_str, "MODE_TBL_SIZE: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
  
      case MODE_TBL_SZ_IDF_NOT_FOUND:
        sprintf (e_str, "MODE_TBL_SIZE: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case MODE_TBL_SZ_IDF_TBL_NUM:
        sprintf (e_str, "MODE_TBL_SIZE: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;

      case MODE_TBL_SZ_IDF_CON_NUM:
        sprintf (e_str, "MODE_TBL_SIZE: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;
   
      case MODE_TBL_SZ_IDF_NO_ENTRY:
        sprintf (e_str, "MODE_TBL_SIZE: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;
  
      case MODE_INFO_NOT_FOUND:
        sprintf (e_str, "FILL_MODE_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case MODE_FILE_OPEN:
        sprintf (e_str, "FILL_MODE_INFO: THE USER DID NOT REQUEST MODE DATA PROCESSING WHEN FILE_OPEN WAS CALLED.");
        break;
  
      case MODE_INFO_DUP:
        sprintf (e_str, "FILL_MODE_INFO: THE EX_INFO STRUCTURE FOR THE MODE DATA HAS NEVER BEEN ALLOCATED.");
        break;
  
      case MODE_INFO_MALLOC:
        sprintf (e_str, "FILL_MODE_INFO: NO MEMORY FOR ARRAY OF FILL_SENSOR STRUCTURES.");
        break;
   
      case MODE_INFO_REALLOC:
        sprintf (e_str, "FILL_MODE_INFO: NO MEMORY FOR EXPANSION OF FILL_SENSOR STRUCTURES.");
        break;
   
      case MODE_INFO_BASE_MALLOC:
        sprintf (e_str, "FILL_MODE_INFO: NO MEMORY FOR ARRAY OF MIN_MAX_TBL_APP STRUCTURES.");
        break;
   
      case MODE_INFO_BASE_REALLOC:
        sprintf (e_str, "FILL_MODE_INFO: NO MEMORY FOR EXPANSION OF MIN_MAX_TBL_APP STRUCTURES.");
        break;
   
      case MODE_INFO_TBL_MALLOC:
        sprintf (e_str, "FILL_MODE_INFO: NO MEMORY FOR TABLE APPLICATION FLAGS.");
        break;
  
      case MODE_INFO_NO_MODES:
        sprintf (e_str, "FILL_MODE_INFO: THERE ARE NO MODE VALUES DEFINED FOR THE DATA SET IN QUESTION.");
        break;
  
      case MODE_UNITS_IND_NOT_FOUND:
        sprintf (e_str, "MODE_UNITS_INDEX: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case MODE_UNITS_FILE_OPEN:
        sprintf (e_str, "MODE_UNITS_INDEX: THE USER DID NOT REQUEST MODE DATA PROCESSING WHEN FILE_OPEN WAS CALLED.");
        break;
  
      case MODE_UNITS_INFO_DUP:
        sprintf (e_str, "MODE_UNITS_INDEX: THE EX_INFO STRUCTURE FOR THE MODE DATA HAS NEVER BEEN ALLOCATED.");
        break;
  
      case MODE_UNITS_NO_MODE:
        sprintf (e_str, "MODE_UNITS_INDEX: REQUESTED MODE NOT FOUND AMONGST FILL INFORMATION.");
        break;
  
      case MODE_UNITS_NO_MATCH:
        sprintf (e_str, "MODE_UNITS_INDEX: REQUESTED DATA LEVEL NOT FOUND.");
        break;
  
      case FILL_WITH_SWEEP_MODE:
        sprintf (e_str, "FILL_MODE_DATA: SWEEP_MODE_DATA AND FILL_MODE_DATA CANNOT BE CALLED IN CONJUNCTION.");
        break;
  
      case MODES_NOT_REQUESTED:
        sprintf (e_str, "FILL_MODE_DATA: THE USER DID NOT CALL FILL_MODE_INFO FOR ANY MODE VALUES.");
        break;
  
      case FILL_MODE_NOT_FOUND:
        sprintf (e_str, "FILL_MODE_DATA: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case FILL_MODE_BASE_TIME_MISSING:
        sprintf (e_str, "FILL_MODE_DATA: THE ROUTINE SET_TIME_VALUES HAS NOT BEEN CALLED PRIOR TO CALLING THE FILL_MODE_DATA ROUTINE.");
        break;
  
      case FILL_MODE_FILE_OPEN:
        sprintf (e_str, "FILL_MODE_DATA: THE USER DID NOT REQUEST MODE DATA PROCESSING WHEN FILE_OPEN WAS CALLED.");
        break;
  
      case FILL_MODE_INFO_DUP:
        sprintf (e_str, "FILL_MODE_DATA: THE EX_INFO STRUCTURE FOR THE MODE DATA HAS NEVER BEEN ALLOCATED.");
        break;
  
      case MODE_DATA_MALLOC:
        sprintf (e_str, "ALLOC_MODE_DATA: NO MEMORY FOR DATA BUFFERS.");
        break;
   
      case MODE_UNITS_MALLOC:
        sprintf (e_str, "ALLOC_MODE_DATA: NO MEMORY FOR CONVERTED UNITS PER BUFFER.");
        break;
   
      case MODE_UNITS_REALLOC:
        sprintf (e_str, "ALLOC_MODE_DATA: NO MEMORY FOR EXPANSION OF CONVERTED UNITS PER BUFFER.");
        break;
   
      case FILL_MODE_ARRAY_MALLOC:
        sprintf (e_str, "ALLOC_MODE_ARRAYS: NO MEMORY FOR FILL_MODE STRUCTURE.");
        break;

      case ALLOC_MODE_INFO_MALLOC:
        sprintf (e_str, "ALLOC_MODE_INFO: NO MEMORY FOR DATA BUFFER INFORMATION.");
        break;
   
      case CREATE_DATA_ALL_MALLOC:
        sprintf (e_str, "CREATE_DATA_STRUCTURE: NO MEMORY FOR ARRAY OF POINTERS FOR IDF_DATA STRUCTURES.");
        break;
  
      case CREATE_DATA_ALL_REALLOC:
        sprintf (e_str, "CREATE_DATA_STRUCTURE: NO MEMORY FOR EXPANSION OF ARRAY OF POINTERS FOR IDF_DATA STRUCTURES.");
        break;
  
      case CREATE_DATA_MALLOC:
        sprintf (e_str, "CREATE_DATA_STRUCTURE: NO MEMORY FOR IDF_DATA STRUCTURE.");
        break;
  
      case CHK_DATA_NOT_FOUND:
        sprintf (e_str, "CHECK_IDF_DATA_MEMORY: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case CUR_TIME_NOT_FOUND:
        sprintf (e_str, "GET_CURRENT_TIME: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case PA_BAD_TIMES:
        sprintf (e_str, "FILL_PITCH_ANGLES: THE END TIME OF THE SAMPLE IS LESS THAN THE START TIME.");
        break;
   
      case PA_BAD_SRC:
        sprintf (e_str, "GET_PITCH_INFO: THE PITCH ANGLE DATA SOURCE IS NON-SCALAR.");
        break;
   
      case PINFO_IDF_MANY_BYTES:
        sprintf (e_str, "GET_PITCH_INFO: NUMBER OF ELEMENTS BEING REQUESTED IS TOO LARGE FOR DATA FIELD.");
        break;
   
      case PINFO_IDF_NOT_FOUND:
        sprintf (e_str, "GET_PITCH_INFO: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case PINFO_IDF_TBL_NUM:
        sprintf (e_str, "GET_PITCH_INFO: THE TABLE NUMBER BEING REQUESTED IS LARGER THAN THE NUMBER OF TABLES.");
        break;
   
      case PINFO_IDF_CON_NUM:
        sprintf (e_str, "GET_PITCH_INFO: THE CONSTANT BEING REQUESTED EXCEEDS THE NUMBER OF DEFINED CONSTANTS.");
        break;

      case PINFO_IDF_NO_ENTRY:
        sprintf (e_str, "GET_PITCH_INFO: THE FIELD BEING REQUESTED IS NOT DEFINED.");
        break;

      case PITCH_MALLOC:
        sprintf (e_str, "ALLOC_PITCH_INFO : NO MEMORY HAS BEEN ALLOCATED FOR PITCH ANGLE STRUCTURE.");
        break;
   
      case PA_TBL_MALLOC:
        sprintf (e_str, "PITCH_ANGLE_TBL_INFO: NO MEMORY FOR TABLE APPLICATION INFORMATION.");
        break;
  
      case PA_DATA_MALLOC:
        sprintf (e_str, "ALLOC_PITCH_INFO: NO MEMORY FOR DATA AND NORMALIZATION VALUES.");
        break;

      case PA_UNIT_MALLOC:
        sprintf (e_str, "ALLOC_PITCH_INFO: NO MEMORY FOR UNIT NORMAL VALUES.");
        break;
  
      case PA_TIME_MALLOC:
        sprintf (e_str, "ALLOC_PITCH_INFO: NO MEMORY FOR TIME OF SAMPLE VALUES.");
        break;
  
      case PA_BAD_FRAC:
        sprintf (e_str, "PROCESS_PITCH_DATA: NEGATIVE FRACTION VALUE CALCULATED.");
        break;

      case PA_UNIT_NORMAL:
        sprintf (e_str, "GET_UNIT_NORMALS: ALL THREE COMPONENTS OF THE APERTURE NORMAL VECTOR WERE NOT DEFINED.");
        break;

      case SWEEP_WITH_FILL:
        sprintf (e_str, "SWEEP_DATA: SWEEP_DATA AND FILL_DATA CANNOT BE CALLED IN CONJUNCTION.");
        break;
  
      case SWEEP_NOT_FOUND:
        sprintf (e_str, "SWEEP_DATA: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case SWEEP_BIN_MISSING:
        sprintf (e_str, "SWEEP_DATA: THE ROUTINE SET_BIN_INFO HAS NOT BEEN CALLED PRIOR TO CALLING THE SWEEP_DATA ROUTINE.");
        break;
 
      case SWEEP_UNITS_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_DATA: NO MEMORY FOR CONVERTED UNITS.");
        break;
   
      case SWEEP_UNITS_REALLOC:
        sprintf (e_str, "ALLOC_SWEEP_DATA: NO MEMORY FOR EXPANSION OF CONVERTED UNITS.");
        break;
  
      case SWEEP_SWP_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_DATA: NO MEMORY FOR CONVERTED SWEEP VALUES.");
        break;
   
      case SWEEP_SWP_REALLOC:
        sprintf (e_str, "ALLOC_SWEEP_DATA: NO MEMORY FOR EXPANSION OF CONVERTED SWEEP VALUES.");
        break;
   
      case SWEEP_DATA_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_DATA: NO MEMORY FOR DATA BUFFER.");
        break;
   
      case SWEEP_INFO_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_INFO: NO MEMORY FOR DATA BUFFER INFORMATION.");
        break;
   
      case SMODE_DATA_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_MODE_DATA: NO MEMORY FOR DATA BUFFERS.");
        break;
   
      case SMODE_UNITS_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_MODE_DATA: NO MEMORY FOR CONVERTED UNITS PER BUFFER.");
        break;
   
      case SMODE_UNITS_REALLOC:
        sprintf (e_str, "ALLOC_SWEEP_MODE_DATA: NO MEMORY FOR EXPANSION OF CONVERTED UNITS PER BUFFER.");
        break;
   
      case ALLOC_SMODE_INFO_MALLOC:
        sprintf (e_str, "ALLOC_SWEEP_MODE_INFO: NO MEMORY FOR DATA BUFFER INFORMATION.");
        break;
   
      case SWEEP_MODES_NOT_REQUESTED:
        sprintf (e_str, "SWEEP_MODE_DATA: THE USER DID NOT CALL FILL_MODE_INFO FOR ANY MODE VALUES.");
        break;
 
      case SWEEP_MODE_NOT_FOUND:
        sprintf (e_str, "SWEEP_MODE_DATA: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case SWEEP_MODE_FILE_OPEN:
        sprintf (e_str, "SWEEP_MODE_DATA: THE USER DID NOT REQUEST MODE DATA PROCESSING WHEN FILE_OPEN WAS CALLED.");
        break;
  
      case SWEEP_MODE_INFO_DUP:
        sprintf (e_str, "SWEEP_MODE_DATA: THE EX_INFO STRUCTURE FOR THE MODE DATA HAS NEVER BEEN ALLOCATED.");
        break;
  
      case SWEEP_MODE_WITH_FILL:
        sprintf (e_str, "SWEEP_MODE_DATA: SWEEP_MODE_DATA AND FILL_MODE_DATA CANNOT BE CALLED IN CONJUNCTION.");
        break;
  
      case SWEEP_DISC_WITH_FILL:
        sprintf (e_str, "SWEEP_DISCONTINUOUS_DATA: SWEEP_DISCONTINUOUS_DATA AND FILL_DISCONTINUOUS_DATA CANNOT BE CALLED IN CONJUNCTION.");
        break;
  
      case SWEEP_DISC_NOT_FOUND:
        sprintf (e_str, "SWEEP_DISCONTINUOUS_DATA: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
   
      case SWEEP_DISC_BIN_MISSING:
        sprintf (e_str, "SWEEP_DISCONTINUOUS_DATA: THE ROUTINE SET_BIN_INFO HAS NOT BEEN CALLED PRIOR TO CALLING THE SWEEP_DISCONTINUOUS_DATA ROUTINE.");
        break;
  
      case SWEEP_DISC_NO_PHI:
        sprintf (e_str, "SWEEP_DISCONTINUOUS_DATA: THE SWEEP_DISCONTINUOUS_DATA ROUTINE DOES NOT HANDLE DATA WITH DIMENSIONS HIGHER THAN THETA.");
        break;
  
      case PA_MAIN_DATA_MISSING:
        sprintf (e_str, "PITCH_ANGLE_SOURCE_STATUS: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case NEXT_FILE_TIME_NOT_FOUND:
        sprintf (e_str, "NEXT_FILE_START_TIME: THE EX_INFO STRUCTURE BEING REQUESTED HAS NEVER BEEN ALLOCATED.");
        break;
  
      case NEXT_FILE_TIME_FILE_OPEN:
        sprintf (e_str, "NEXT_FILE_START_TIME: THE USER DID NOT REQUEST MODE DATA PROCESSING WHEN FILE_OPEN WAS CALLED.");
        break;
  
      case NEXT_FILE_TIME_INFO_DUP:
        sprintf (e_str, "NEXT_FILE_START_TIME: THE EX_INFO STRUCTURE FOR THE MODE DATA HAS NEVER BEEN ALLOCATED.");
        break;
  
      default:
        sprintf (e_str, "ERROR CODE %d NOT RECOGNIZED BY IDFS READ ROUTINES.", error_code);
        break;
    }
}
