#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                           RawToFloat                                        *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    Converts a UDF data value into a double                                   *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    float DaTaIn               the data value to be applied in the equation  *
 *    char T                     the input type                                *
 *                                  <0 = converted float;                      *
 *                                   0 = unsigned;                             *
 *                                   1 = signed                                *
 *                                  >1 = idfs float                            *
 *                                                                             *
 *  USAGE                                                                      *
 *    V = TrueVal (DaTaIn)                                                     *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    ir_intfp2fp ()       converts idfs float to system float                 *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    register float *C          pointer to the coefficients                   *
 *    register float V           input data cast as float                      *
 *    register float *stop_loop  loop termination variable                     *
 *    register double x          the result of x**0, x**1, x**2, etc.          *
 *    register double sum        summation variable (the resultant)            *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

ReaL_8 RawToFloat (ByTe_4 *DaTaIn, ByTe_1 T)
{
   ReaL_8 V;

   if (T < 0)                                        /* input is float?      */
      V = *(ReaL_8 *)DaTaIn;                         /* cast it here         */
   else                                              /* an IDFS type value   */
   {                                                 /* BEGIN IDFS VALUE     */
      if (T < 2)                                     /* some kind of integer */
      {                                              /* BEGIN SET INTEGER    */
         if (T == 0)                                 /* unsigned?            */
            V = (u_ByTe_4)*DaTaIn;                   /* set it here          */
         else                                        /* must be signed       */
            V = *DaTaIn;                             /* so set it here       */
      }                                              /* END SET INTEGER      */
      else                                           /* its a float!         */
        V = ir_intfp2fp ((u_ByTe_4)*DaTaIn, T);      /* convert it here      */
   }                                                 /* END IDFS VALUE       */
   
   return (V);                                       /* send back value      */
}
