#include "util_str.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                           IR_SAME_PITCH_TIME SUBROUTINE                     *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine is called to set/reset the time values for the data being   *
 *  processed.  This is done since the data set could have different TIME_OFF  *
 *  values for the sensors within the data set.  The pitch angle software      *
 *  assumes that all three sensors from the pitch angle data set have the same *
 *  time value for all data values.  To accomodate this requirement, the       *
 *  current algorithm uses the time from the first sensor processed from the   *
 *  pitch angle data set to dictate the time values, thereby, ignoring the     *
 *  TIME_OFFSET values for all other sensors.                                  *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    struct pitch_info *pa_ptr  a pointer to the structure that holds pitch   *
 *                               angle information                             *
 *    char set_time              flag indicating if the data sample is the one *
 *                               that controls the timing for the data set     *
 *    short which_comp           index specifying which of the 3 components    *
 *                               is being processed                            *
 *                                                                             *
 *  USAGE                                                                      *
 *    ir_same_pitch_time (&pa_ptr, set_time, which_comp)                       *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    struct idf_data *PA_DATA     structure holding the data for the pitch    *
 *                                 angle component being processed             *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void ir_same_pitch_time (struct pitch_info *pa_ptr, ByTe_1 set_time, 
                         ByTe_2 which_comp)
{
   struct idf_data *PA_DATA;

   /***************************************************************************/
   /*  Save the time values returned for this component and this time will be */
   /*  used for the other two components from this data set.                  */
   /***************************************************************************/

   PA_DATA = (struct idf_data *) pa_ptr->idf_data_ptr[which_comp];
   if (set_time)
    {
      pa_ptr->ptimes.byear = PA_DATA->byear;
      pa_ptr->ptimes.bday = PA_DATA->bday;
      pa_ptr->ptimes.bmilli = PA_DATA->bmilli;
      pa_ptr->ptimes.bnano = PA_DATA->bnano;
      pa_ptr->ptimes.eyear = PA_DATA->eyear;
      pa_ptr->ptimes.eday = PA_DATA->eday;
      pa_ptr->ptimes.emilli = PA_DATA->emilli;
      pa_ptr->ptimes.enano = PA_DATA->enano;
    }

   /***************************************************************************/
   /*  Reset the time values to the time defined by the controlling component,*/
   /*  which is the first component processed for the data set.               */
   /***************************************************************************/

   else
    {
      PA_DATA->byear = pa_ptr->ptimes.byear;
      PA_DATA->bday = pa_ptr->ptimes.bday;
      PA_DATA->bmilli = pa_ptr->ptimes.bmilli;
      PA_DATA->bnano = pa_ptr->ptimes.bnano;
      PA_DATA->eyear = pa_ptr->ptimes.eyear;
      PA_DATA->eday = pa_ptr->ptimes.eday;
      PA_DATA->emilli = pa_ptr->ptimes.emilli;
      PA_DATA->enano = pa_ptr->ptimes.enano;
    }
}
