#include <stdlib.h>
#include "util_str.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                       IR_PITCH_ANGLE_TBL_INFO SUBROUTINE                   *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine is called to retrieve table information for pitch angle    *
 *  data values.  This information is used to convert the pitch angle data    *
 *  values into the correct units.                                            *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    None                                                                    *
 *                                                                            *
 *  USAGE                                                                     *
 *    x = ir_pitch_angle_tbl_info ()                                          *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    sizeof ()                    the size of the specified object in bytes  *
 *    malloc()                     allocates memory                           *
 *    read_idf()                   reads information from the VIDF file       *
 *    ir_get_pinfo_rval ()         returns error code unique to this module   *
 *                                 for each possible READ_IDF() error code    *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    struct general_info ginfo    structure holding information concerning   *
 *                                 the experiment that is being processed     *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct experiment_info *ex   pointer to the structure that holds        *
 *                                 specific experiment information            *
 *    register struct pitch_info   pointer to the structure that holds pitch  *
 *         *pa_ptr                 angle information                          *
 *    register short i             looping variable                           *
 *    unsigned int bytes           the number of bytes to allocate            *
 *    long ret_val                 holds value returned by called module      *
 *    long offset                  index into allocated memory                *
 *    short tV                     temporary variable                         *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

ByTe_2 ir_pitch_angle_tbl_info (void)
{
   extern struct general_info ginfo;

   struct experiment_info *ex;
   register struct pitch_info *pa_ptr;
   register ByTe_2 i;
   size_t bytes;
   ByTe_4 ret_val, offset;
   ByTe_2 tV;

   /*************************************************************************/
   /*  Retrieve the table information for pitch angle data values.          */
   /*  Allocate the space since the number of tables varies.                */
   /*************************************************************************/

   ex = ginfo.expt;
   pa_ptr = ex->pitch_angles;

   ret_val = read_idf (ex->data_key, ex->exten, ex->version, (ByTe_1 *) &tV,
                       _PaAppS, 0, 0L, 1);
   if (ret_val < 0)
     return (ir_get_pinfo_rval (ret_val));
   pa_ptr->num_tbls = (ByTe_1) tV;

   bytes = (sizeof (ByTe_2) + sizeof (ByTe_1)) * pa_ptr->num_tbls;
   if (bytes <= 0)
     return (PA_TBL_MALLOC);

   if ((pa_ptr->base_tbls = malloc (bytes)) == NO_MEMORY)
     return (PA_TBL_MALLOC);
   pa_ptr->tbl_oper = (ByTe_2 *) pa_ptr->base_tbls;
   offset = pa_ptr->num_tbls * sizeof (ByTe_2);
   pa_ptr->tbl_apply = (ByTe_1 *) ((ByTe_1 *)pa_ptr->base_tbls + offset);

   /*************************************************************************/
   /*  The IDFS software says tables to apply are chars BUT vidf defines    */
   /*  PA_TBLS as shorts.  Read into tbl_oper space and copy values into    */
   /*  tbl_apply to save as chars.                                          */
   /*************************************************************************/

   if (pa_ptr->num_tbls > 0) 
   {
      ret_val = read_idf (ex->data_key, ex->exten, ex->version,
                       (ByTe_1 *) pa_ptr->tbl_oper, _PaTblS, 0, 0L, -1);
      if (ret_val < 0)
        return (ir_get_pinfo_rval (ret_val));

      for (i = 0; i < pa_ptr->num_tbls; ++i)
         *(pa_ptr->tbl_apply + i) = (ByTe_1) *(pa_ptr->tbl_oper + i);

      ret_val = read_idf (ex->data_key, ex->exten, ex->version,
                       (ByTe_1 *) pa_ptr->tbl_oper, _PaOpS, 0, 0L, -1);
      if (ret_val < 0)
        return (ir_get_pinfo_rval (ret_val));
   }
   return (ALL_OKAY);
}
