#include <stdio.h>
#include <stdlib.h>
#include "OpSySInD.h"
#include "util_str.h"
#include "gen_defs.h" 
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                         IR_FREE_EX_STRUCTURE SUBROUTINE                    *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine is called to free all allocated memory associated with the *
 *  experiment_info structure specified by the given parameter.               *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    struct experiment_info   a pointer to the structure that holds specific *
 *          *ex                experiment information                         *
 *                                                                            *
 *  USAGE                                                                     *
 *    ir_free_ex_structure (ex)                                               *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    free ()                  frees previously allocated memory              *
 *    close()                  closes the file associated with the file       *
 *                             descriptor specified                           *
 *    ir_free_vidf_structure ()   frees memory allocated for VIDF processing  *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    None                                                                    *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct sensor_tables     a pointer to the structure which holds the     *
 *         *sptr               various information for the tables utilized by *
 *                             sensor-table combination being processed       *
 *    struct sensor_tables     loop termination variable                      *
 *       *stop_sptr                                                           *
 *    struct mode_tables       a pointer to the structure which holds the     *
 *         *mode_ptr           mode-dependent table information               *
 *    struct mode_tables       loop termination variable                      *
 *       *stop_mode_ptr                                                       *
 *    struct fill_sensor       pointer to the fill_sensor structure being     *
 *          *fptr              processed                                      *
 *    struct fill_sensor       pointer to the structure being processed for   *
 *          *minfo             the mode in question                           * 
 *    struct in_fill *mptr     pointer to the data level combination being    *
 *                             processed                                      *
 *    struct fill_discontinuous  pointer to the fill_discontinuous structure  *
 *         *disc_ptr           being processed                                *
 *    register short i, j      looping variables                              *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            * 
 *  MODS                                                                      * 
 *    4/25/97  ChrisG - reduced number of mallocs                             * 
 ******************************************************************************/

void ir_free_ex_structure (struct experiment_info  *ex)
{
   register struct sensor_tables *sptr, *stop_sptr;
   struct mode_tables *mode_ptr, *stop_mode_ptr;
   struct crit_action_info *crit_act_ptr;
   register ByTe_2 i;

  /***************************************************************/
  /*  Free various table information.                            */
  /***************************************************************/

   if (ex->bmem.base_data != NO_MEMORY) {
      free (ex->bmem.base_data);
      ex->bmem.base_data = NO_MEMORY;
      ex->DATA_MEM = NO_MEMORY;
      ex->CAL_USE = NO_MEMORY;
      ex->CSET_NUM = NO_MEMORY;
      ex->cal_target = NO_MEMORY;
      ex->cal_wlen = NO_MEMORY;
      ex->tbl_type = NO_MEMORY;
      ex->tbl_var = NO_MEMORY;
      ex->tbl_expand = NO_MEMORY;
      ex->d_type = NO_MEMORY;
      ex->sen_tdw_len = NO_MEMORY;
      ex->sen_status = NO_MEMORY;
      ex->time_off = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free the memory for the header information.                */
  /***************************************************************/

   if (ex->bmem.base_hdr != NO_MEMORY) {
      free (ex->bmem.base_hdr);
      ex->bmem.base_hdr = NO_MEMORY;
      ex->HEADER_MEM = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free the memory that holds the pointers to the header and  */
  /*  data elements.                                             */
  /***************************************************************/

   if (ex->bmem.base_info_ptr != NO_MEMORY) {
      free (ex->bmem.base_info_ptr);
      ex->bmem.base_info_ptr = NO_MEMORY;
      ex->info_ptr = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free memory allocated for constant id and values.          */
  /***************************************************************/

   if (ex->bmem.base_constant != NO_MEMORY) {
      free (ex->bmem.base_constant);
      ex->bmem.base_constant = NO_MEMORY;
      ex->constants = NO_MEMORY;
   }

  /****************************************************************/
  /*  Free flags and indexes for sensor information.              */
  /****************************************************************/

   if (ex->sensors_needed != NO_MEMORY) {
      free ((void *) ex->sensors_needed);
      ex->sensors_needed = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free the array of sensor_tables structures.                */
  /***************************************************************/

   if (ex->bmem.base_sen_ptr != NO_MEMORY) {

  /***************************************************************/
  /*  Free tables for each sensor table combination processed.   */
  /***************************************************************/

      sptr = ex->sen_tbl_ptr;
      stop_sptr = ex->sen_tbl_ptr + ex->num_combo;
      for (; sptr < stop_sptr; ++sptr) {
         if (sptr->base_misc_tbls != NO_MEMORY) {
            free (sptr->base_misc_tbls);
            sptr->base_misc_tbls = NO_MEMORY;
         }
  
         if (sptr->base_tbls != NO_MEMORY) {
            free (sptr->base_tbls);
            sptr->base_tbls = NO_MEMORY;
         }
    
  /************************************************************/
  /*  Free the table that holds the CRIT_ACTION values.       */
  /************************************************************/

         if (sptr->base_crit_action != NO_MEMORY) {
            for (i = 0; i < ex->crit_action; ++i) {
               crit_act_ptr = sptr->act_ptr + i;
               if (crit_act_ptr->base_action != NO_MEMORY) {
                  free (crit_act_ptr->base_action);
                  crit_act_ptr->base_action = NO_MEMORY;
                  crit_act_ptr->crit_action = NO_MEMORY;
               }
            }

            free (sptr->base_crit_action);
            sptr->base_crit_action = NO_MEMORY;
            sptr->act_ptr = NO_MEMORY;
         }
      }

      free (ex->bmem.base_sen_ptr);
      ex->bmem.base_sen_ptr = NO_MEMORY;
      ex->sen_tbl_ptr = NO_MEMORY;
      ex->num_combo = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free the array of mode_tables structures.                  */
  /***************************************************************/

   if (ex->bmem.base_mode_ptr != NO_MEMORY) {

  /***************************************************************/
  /*  Free tables for each mode defined.                         */
  /***************************************************************/

      mode_ptr = ex->mode_tbl_ptr;
      stop_mode_ptr = ex->mode_tbl_ptr + ex->num_modes;
      for (; mode_ptr < stop_mode_ptr; ++mode_ptr) {
         if (mode_ptr->base_misc_tbls != NO_MEMORY) {
            free (mode_ptr->base_misc_tbls);
            mode_ptr->base_misc_tbls = NO_MEMORY;
         }
  
         if (mode_ptr->base_tbls != NO_MEMORY) {
            free (mode_ptr->base_tbls);
            mode_ptr->base_tbls = NO_MEMORY;
         }
      }

      free (ex->bmem.base_mode_ptr);
      ex->bmem.base_mode_ptr = NO_MEMORY;
      ex->mode_tbl_ptr = NO_MEMORY;
   }
   
  /***************************************************************/
  /*  Free array of indexes into sensor_tables structures.       */
  /***************************************************************/

   if (ex->bmem.base_tbl_index != NO_MEMORY) {
      free (ex->bmem.base_tbl_index);
      ex->bmem.base_tbl_index = NO_MEMORY;
      ex->index_sen_tbl = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free the pitch angle information.  No need to free the     */
  /*  idf_data_ptr since the calling module will do that.        */
  /***************************************************************/

   if (ex->bmem.base_pitch_info != NO_MEMORY) {
      if (ex->pitch_angles->base_tbls != NO_MEMORY)
        free (ex->pitch_angles->base_tbls);

      if (ex->pitch_angles->base_data != NO_MEMORY)
        free (ex->pitch_angles->base_data);

      free (ex->bmem.base_pitch_info);
      ex->bmem.base_pitch_info = NO_MEMORY;
      ex->pitch_angles = NO_MEMORY;
   }

  /***************************************************************/
  /*  Free any memory that may have been allocated in order to   */
  /*  process the VIDF definition file from memory.              */
  /***************************************************************/

    ir_free_vidf_structure (ex);

  /***************************************************************/
  /*  Close the opened data, header and vidf files.              */
  /***************************************************************/
  
   if (ex->fdh != -1) { close (ex->fdh); ex->fdh = -1; }
   if (ex->fdd != -1) { close (ex->fdd); ex->fdd = -1; }
   if (ex->fdi != -1) { close (ex->fdi); ex->fdi = -1; }

    ex->data_key = 0;
}
