#include <stdio.h>
#include <stdlib.h>
#include "util_str.h"
#include "gen_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                            IR_COUNT_COMBO SUBROUTINE                       *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine determines the number of different combinations possible   *
 *  for the tables used by the sensors being returned.  The offset values for *
 *  the tables and the CRIT_STATUS arrays are compared to determine the       *
 *  number of unique combinations for these tables, which are stored in       *
 *  the sensor structure by the calling routine.                              *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    char *oInfo              an array of 1 flag per table which indicates   *
 *                             if the table has different offset values       *
 *    char *cInfo              an array of 1 flag per table which indicates   *
 *                             if there are critical action values present    *
 *    long *tOffs              an array holding the table offsets for each    *
 *                             table                                          *
 *    long *crB                an array holding the critical action bytes     *
 *                             for table                                      *
 *  USAGE                                                                     *
 *    x = ir_count_combo(oInfo, cInfo, tOffs, crB )                           *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    sizeof ()                the size of the specified object in bytes      *
 *    malloc()                 allocates memory                               *
 *    free ()                  frees allocated memory                         *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    struct general_info      structure that holds information concerning    *
 *        ginfo                the experiment that is being processed         *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct experiment_info   a pointer to the structure that holds specific *
 *          *ex                experiment information                         *
 *    register short i, j      looping variables                              *
 *    long *l1                 pointer to the current sensor table being      *
 *                             processed                                      *
 *    short num_combo          the number of unique table combinations needed *
 *                             for all sensors for the virtual instrument     *
 *                             being processed                                *
 *    char toFlg               some tables have different offset flag         *
 *    char crFlg               some tables have different critial bytes flag  *
 *    void *tmp_ptr            pointer which holds address passed back by the *
 *                             call to the MALLOC routine                     *
 *    void *base_match         pointer to the memory allocated for the array  *
 *                             that holds the sensor number which does not    *
 *                             match the combo being tested                   *
 *    void *base_val           pointer to the memory allocated to hold the    *
 *                             comparison (base) offset values for each table *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

ByTe_2 ir_count_combo (ByTe_1 *oInfo, ByTe_1 *cInfo, ByTe_4 *tOffs, 
                                                            ByTe_1 *crB)
{
   extern struct general_info ginfo;

   struct experiment_info *ex;
   register ByTe_2 i, j;
   ByTe_4 *l1, BaseTO, sL, sS, nTbl, nSen;
   ByTe_4 BaseSen, NextSen;
   ByTe_2 num_combo;
   ByTe_2 *s1;
   ByTe_1 toFlg;
   ByTe_1 crFlg, *c1, BaseCR, SameCombo, ToS, CrS;

   sL = sizeof(ByTe_4);
   sS = sizeof(ByTe_2);

  /***************************************************************************/
  /*  Determine the number of sensors used from the virtual instrument being */
  /*  processed and initialize the index_sen_tbl value to the first combo.   */
  /*  (All used sensors are initially set to use the same combo)             */
  /***************************************************************************/

   ex = ginfo.expt;
   nSen = ex->num_sensor;
   nTbl = ex->num_tbls;

  /***************************************************************************/
  /*  Check to see if there are any differences in the tables due either to  */
  /*  sensors having different table offsets or using different critical     */
  /*  status bytes.                                                          */
  /***************************************************************************/

   toFlg = 0;
   crFlg = 0;
   for (i = 0; i < nTbl; ++i) {
      if ( *(oInfo + i) ) { toFlg = 1; }
      if ( *(cInfo + i) ) { crFlg = 1; }
   }

  /***************************************************************************/
  /*  If there is more than one critical action table defined, for now, set  */
  /*  it up so that each sensor needs its own structure.                     */
  /***************************************************************************/

   if (ex->crit_action > 1) {
      num_combo = 0;
      s1 = ex->index_sen_tbl;
      for (i = 0; i < nSen; ++i, ++s1) {
         if ( *s1 >= 0 ) {
            *s1 = num_combo;
            ++num_combo;
         }
      }
   } else if (toFlg || crFlg) {

  /***************************************************************************/
  /*  If either toFlg or crFlg is 1 then there are multiple combinations     */
  /*  which are determined in this section of code.                          */
  /***************************************************************************/

      BaseSen = -1;
      s1 = ex->index_sen_tbl;
      for (i = 0; i < nSen; ++i, ++s1) {
         if (*s1 >=  0) {
            if ( BaseSen < 0 ) { BaseSen = i; }
            *s1 = -2;
         }
      } 

      NextSen = -1;
      num_combo = 0;

      while ( BaseSen < nSen ) {
         *(ex->index_sen_tbl + BaseSen) = num_combo;
         BaseTO = *(tOffs + BaseSen);
	 BaseCR = ( *cInfo ) ? *(crB + BaseSen) : 0;
	 s1 = ex->index_sen_tbl + BaseSen + 1;
         for (i=BaseSen + 1; i < nSen; ++i, ++s1) {
            if (*s1 == -2) {
               l1 = tOffs;
               c1 = crB;
               SameCombo = 1;

               for (j=0; j < nTbl; ++j, l1 += nSen, c1 += nSen) {
	          if (*(cInfo + j )) { 
	             CrS = (BaseCR != *(c1 + i)) ? 1 : 0; 
	          } else { CrS = 0; }   
                  ToS = (BaseTO != *(l1 + i)) ? 1 : 0;   
	          if ( CrS || ToS ) {
	             SameCombo = 0;
                     if ( NextSen < 0 ) { NextSen = i; }
                     break; 
                  }
               }

               if ( SameCombo == 1 ) { *s1 = num_combo; } 
            }
         }

         ++num_combo;
         if ( NextSen >= 0 ) {
            BaseSen = NextSen;
            NextSen = -1;
         } else { BaseSen = nSen; }
      }

   } else { num_combo = 1; }

  return (num_combo);
}
