#include <stdlib.h>
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                      IR_CHECK_CAL_SIZE SUBROUTINE                          *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine is called to determine if the array that holds the cal.    *
 *  data is of sufficient size.  If the total number of calibration values    *
 *  exceeds the size of the memory allocated to return this information, the  *
 *  array is resized.                                                         *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    void *idf_data_ptr           ptr to memory location for the structure   *
 *                                 that holds returned data values (read_drec)*
 *                                                                            *
 *  USAGE                                                                     *
 *    x = ir_check_cal_size (idf_data_ptr)                                    *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    malloc()                     allocates memory                           *
 *    sizeof ()                    the size of the specified object in bytes  *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    struct general_info ginfo    structure that holds information concerning*
 *                                 the experiment that is being processed     *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct idf_data *EXP_DATA    structure that holds all of the currently  *
 *                                 returned data values to be processed       *
 *    struct experiment_info *ex   a pointer to the structure that holds      *
 *                                 specific experiment information            *
 *    size_t B                     the number of bytes to allocate            *
 *    register short i             looping variable                           *
 *    long num_cal                 the number of calibration values for all   *
 *                                 calibration sets                           *
 *    void *tmpP                   pointer which holds address passed back by *
 *                                 the call to the MALLOC routine             *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 ******************************************************************************/

ByTe_2 ir_check_cal_size (void *idf_data_ptr)
{
   extern struct general_info ginfo;

   struct idf_data *EXP_DATA;
   struct experiment_info *ex;
   size_t B;
   register u_ByTe_2 *uS, *EnD;
   ByTe_4 num_cal;
   void *tmpP;

  /************************************************************************/
  /*  Determine how many calibration values will be returned for all cal. */
  /*  sets for this virtual instrument.                                   */
  /************************************************************************/

   EXP_DATA = (struct idf_data *) idf_data_ptr;
   ex = ginfo.expt;

   if ( ex->cal_sets == 0 ) { return (ALL_OKAY); }

   EnD = ex->CSET_NUM + ex->cal_sets;
   for (uS = ex->CSET_NUM, num_cal = 0; uS < EnD; )
     num_cal += *uS++;

  /************************************************************************/
  /*  Allocate space to hold the calibration data that is to be returned  */
  /*  to the user, which are floats, if no memory has been allocated yet. */
  /*  CAG 12/16/08 - removed a realloc in favor of a free/malloc          */
  /************************************************************************/

   EXP_DATA->cal_len = num_cal;
   B = sizeof(ByTe_4) * num_cal;
   if (B > EXP_DATA->cal_size) {
      if (EXP_DATA->base_cal != NO_MEMORY) { 
         free(EXP_DATA->base_cal);
         EXP_DATA->base_cal = NO_MEMORY;
         EXP_DATA->cal_size = 0;
      }

      if ((tmpP = malloc (B)) == NO_MEMORY) { return (NUM_CAL_MALLOC); }
      EXP_DATA->base_cal = tmpP;
      EXP_DATA->cal_data = (ByTe_4 *)EXP_DATA->base_cal;
      EXP_DATA->cal_size = B;

      if (EXP_DATA->base_cset == NO_MEMORY) {
         B = num_cal * sizeof (u_ByTe_2);
         if ((tmpP = malloc (B)) == NO_MEMORY) { return (RESET_CSET_MALLOC); }
         EXP_DATA->base_cset = tmpP;
         EXP_DATA->cset_num = (u_ByTe_2 *)EXP_DATA->base_cset;
      }
   }

  return (ALL_OKAY);
}
