#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

void ReOrderUdf (ByTe_2 Object)
{

   extern struct general_info ginfo;
   register struct experiment_info *ex;
   register struct ptr_rec *ptr; 
   ByTe_4 N, Sz;
   ByTe_4 Offset;
   u_ByTe_2 *V;

  /**************************************************************************/
  /*  Set a pointer to the structure which holds all pointers for header    */
  /*  and data information for the experiment currently being processed.    */
  /**************************************************************************/

   ex = ginfo.expt;
   ptr = ex->info_ptr;
 
   switch (Object) {
      case 0: 
         ReOrderBytes (2, (u_ByTe_1 *)(ex->HEADER_MEM + 2), 2);
         ReOrderBytes (4, (u_ByTe_1 *)(ex->HEADER_MEM + 8), 4);
         if (ex->smp_id == 3) {
            ReOrderBytes (2, (u_ByTe_1 *)(ex->HEADER_MEM + 24), 5);
            Offset = 34;
         } else {
            ReOrderBytes (2, (u_ByTe_1 *)(ex->HEADER_MEM + 24), 2);
            Offset = 28;
         }
         V  = (u_ByTe_2 *)(ex->HEADER_MEM + 24);
         N = (ex->smp_id == 2) ? 1 : V[1];
         N += V[0];
         ReOrderBytes (2, (u_ByTe_1 *)(ex->HEADER_MEM + Offset), N);
      break;
      case 1:
         N = 4 + ex->max_nss;
         ReOrderBytes (4, (u_ByTe_1 *)ex->DATA_MEM, N);
         if ((ptr->NumPreAnc > 0) && (ex->AncPBytes > 1)) {
            Offset = N * sizeof(ByTe_4);
            N = ptr->NumPreAnc;
            Sz = ex->AncPBytes;
            ReOrderBytes (Sz, (u_ByTe_1 *)(ex->DATA_MEM + Offset), N);
         }
      break;
      case 2:
         if (ex->DswaP) {
            Offset = (4 + ex->max_nss) * sizeof(ByTe_4) + ex->accum_ss_sz/8;
            if (ex->accum_ss_sz % 8 != 0) ++Offset;
            if (ptr->NumPreAnc > 0) 
               Offset += ptr->NumPreAnc * ex->AncPBytes;
            Sz = ex->tdw_len / 8 + 1;
            if (ex->tdw_len % 8 == 0) --Sz;
            if (Sz == 3) ++Sz;
            N = *ptr->N_SAMPLE * *ptr->N_SEN;
            if (ex->smp_id == 3)
               N *= *ptr->N_COLS;
            ReOrderBytes (Sz, (u_ByTe_1 *)(ex->DATA_MEM + Offset), N);

            Offset += N * Sz;
            if ((ptr->NumGenAnc > 0) && (ex->AncGBytes > 1)) {
               N = ptr->NumGenAnc;
               Sz = ex->AncGBytes;
               ReOrderBytes (Sz, (u_ByTe_1 *)(ex->DATA_MEM + Offset), N);
            } 

            Offset += ptr->NumGenAnc * ex->AncGBytes;
            if ((ptr->NumSenAnc > 0) && (ex->AncSBytes > 1)) {
               N = ptr->NumSenAnc;
               Sz = ex->AncSBytes;
               ReOrderBytes (Sz, (u_ByTe_1 *)(ex->DATA_MEM + Offset), N);
            } 
         }
         ex->DswaP = 0;
      break;
   }
}
