#include <stdlib.h>
#include "OpSySInD.h"
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

void  FreeTblSen (struct experiment_info *ex)
{
   struct sensor_tables *sptr;
   struct mode_tables *mode_ptr;
   struct crit_action_info *crit_act_ptr;
   ByTe_2 sen, i;

   /*******************************************************************/
   /*  Free the tables for each sensor table combination processed.   */
   /*******************************************************************/

   for (sen = 0; sen < ex->num_combo; ++sen) {
      sptr = ex->sen_tbl_ptr + sen;

      /************************************************************/
      /*  Free information concerning the tables.                 */
      /************************************************************/

      if (sptr->base_misc_tbls != NO_MEMORY) {
         free (sptr->base_misc_tbls);
         sptr->base_misc_tbls = NO_MEMORY;
      }

      /************************************************************/
      /*  Free the table values.                                  */
      /************************************************************/

      if (sptr->base_tbls != NO_MEMORY) {
         free (sptr->base_tbls);
         sptr->base_tbls = NO_MEMORY;
      }

      /************************************************************/
      /*  Free the structures that holds the CRIT_ACTION values.  */
      /************************************************************/
   
      if (sptr->base_crit_action != NO_MEMORY) {
         for (i = 0; i < ex->crit_action; ++i) {
            crit_act_ptr = sptr->act_ptr + i;
            if (crit_act_ptr->base_action != NO_MEMORY) {
               free (crit_act_ptr->base_action);
               crit_act_ptr->base_action = NO_MEMORY;
               crit_act_ptr->crit_action = NO_MEMORY;
            }
         }

         free (sptr->base_crit_action);
         sptr->base_crit_action = NO_MEMORY;
         sptr->act_ptr = NO_MEMORY;
      }
   }

   /***************************************************************/
   /*  Free the array of sensor_tables structures.                */
   /***************************************************************/

   if (ex->bmem.base_sen_ptr != NO_MEMORY) {
      free (ex->bmem.base_sen_ptr);
      ex->bmem.base_sen_ptr = NO_MEMORY;
   }
   
   /*******************************************************************/
   /*  Free the tables for each mode processed.                       */
   /*******************************************************************/

   for (i = 0; i < ex->num_modes; ++i) {
      mode_ptr = ex->mode_tbl_ptr + i;

      /************************************************************/
      /*  Free information concerning the tables.                 */
      /************************************************************/

      if (mode_ptr->base_misc_tbls != NO_MEMORY) {
         free (mode_ptr->base_misc_tbls);
         mode_ptr->base_misc_tbls = NO_MEMORY;
      }

      /************************************************************/
      /*  Free the table values.                                  */
      /************************************************************/

      if (mode_ptr->base_tbls != NO_MEMORY) {
         free (mode_ptr->base_tbls);
         mode_ptr->base_tbls = NO_MEMORY;
      }
   }

   /***************************************************************/
   /*  Free the array of mode_tables structures.                  */
   /***************************************************************/

   if (ex->bmem.base_mode_ptr != NO_MEMORY) {
      free (ex->bmem.base_mode_ptr);
      ex->bmem.base_mode_ptr = NO_MEMORY;
   }
   
   /****************************************************************/
   /*  Free the indexes for sensor table combinations.             */
   /****************************************************************/

   if (ex->bmem.base_tbl_index != NO_MEMORY) {
      free (ex->bmem.base_tbl_index);
      ex->bmem.base_tbl_index = NO_MEMORY;
   }

   ex->num_combo = 0;
}
