#include <math.h>
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                           COMBINE_OP SUBROUTINE                            *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *   This routine is used to combine the results in the permanent accumulator *
 *  and the temporary accumulator built using the tables requested from the   *
 *  VIDF file.                                                                *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    double *To     pointer to array holding the returned values             *
 *    double *From   pointer to the temporary accumulator                     *
 *    long  N       the number of elements being returned                     *
 *    short Op      the operation                                             *
 *                                                                            *
 *  USAGE                                                                     *
 *    CombineOp (&ret_data, &accum_data, num_data, oper)                      *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    None                                                                    *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    None                                                                    *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    register float *d1,*d2     pointers to float values                     *
 *    register float *dEnD       loop end variable                            *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

void CombineOp (ReaL_8 *To, ReaL_8 *From, ByTe_4 N, ByTe_2 Op)
{
   register ReaL_8 *d1, *d2, *dEnD;

   d1   = To;
   d2   = From;
   dEnD = To + N;

   switch (Op)                                    /* switch on operation     */
   {                                              /* BEGIN OPERATION SWITCH  */
       case 0:                                    /* START EQUAL CASE        */
          for ( ; d1 < dEnD; )                    /* loop over data          */
            *d1++ = *d2++;                        /* do equal operation      */
       break;                                     /* STOP EQULA CASE         */
       case 1:                                    /* START ADD CASE          */
          for ( ; d1 < dEnD; )                    /* loop over data          */
            *d1++ += *d2++;                       /* do operation            */
       break;                                     /* STOP ADD CASE           */
       case 2:                                    /* START SUBTRACT CASE     */
          for ( ; d1 < dEnD; )                    /* loop over data          */
            *d1++ -= *d2++;                       /* do operation            */
       break;                                     /* STOP SUBTRACT CASE      */
       case 3:                                    /* START MULTIPLY CASE     */
          for ( ; d1 < dEnD; )                    /* loop over data          */
            *d1++ *= *d2++;                       /* do operation            */
       break;                                     /* STOP MULTIPLY CASE      */
       case 4:                                    /* START DIVIDE CASE       */
          for ( ; d1 < dEnD; )                    /* loop over data          */
            *d1++ /= *d2++;                       /* do operation            */
       break;                                     /* STOP DIVIDE CASE        */
       case 5:                                    /* START AND CASE          */
          for ( ; d1 < dEnD; ++d1 )               /* loop over data          */
            *d1 = (ByTe_4)*d1 & (ByTe_4)*d2++;    /* do operation            */
       break;                                     /* STOP AND CASE           */
       case 6:                                    /* START OR CASE           */
          for ( ; d1 < dEnD; ++d1)                /* loop over data          */
            *d1 = (ByTe_4)*d1 | (ByTe_4)*d2++;    /* do operation            */
       break;                                     /* STOP OR CASE            */
       case 7:                                    /* START OR CASE           */
          for ( ; d1 < dEnD; ++d1)                /* loop over data          */
            *d1 = (ByTe_4)*d1 >> (ByTe_4)*d2++;   /* do operation            */
       break;                                     /* STOP OR CASE            */
       case 8:                                    /* START LEFT SHIFT CASE   */
          for ( ; d1 < dEnD; ++d1)                /* loop over data          */
            *d1 = (ByTe_4)*d1 << (ByTe_4)*d2++;   /* do operation            */
       break;                                     /* STOP LEFT SHIFT CASE    */
       case 9:                                    /* START POWER CASE        */
          for ( ; d1 < dEnD; ++d1, ++d2)          /* loop over data          */
            *d1 = pow ((ReaL_8)*d1, (ReaL_8)*d2); /* do operation            */
       break;                                     /* STOP POWER CASE         */
       case 10:                                   /* START MOD CASE          */
          for ( ; d1 < dEnD; ++d1 )               /* loop over data          */
            *d1 = (ByTe_4)*d1 % (ByTe_4)*d2++;    /* do operation            */
       break;                                     /* STOP AND CASE           */
   }                                              /* BEGIN OPERATION SWITCH  */
}
