#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

ByTe_2 BuildMatrix (u_ByTe_4 KeY, ByTe_1 *Ex, u_ByTe_2 vN, void *UDF, 
                    ByTe_2 SeN, ByTe_1 FwD, struct MatrixData *Md )
{
   extern struct general_info ginfo;
   struct idf_data  *ExDa;
   struct experiment_info *ex;
   struct ptr_rec *pTr; 

   ReaL_4 *f1;
   size_t TBytes;
   ByTe_4 LastCN;
   ByTe_2 rV, ColN;

   /*************************************************************************/
   /*  Locate the information associated with the Key to be used            */
   /*************************************************************************/

   rV = ir_locate_ex (KeY, Ex, vN, 0); 
   if (rV != ALL_OKAY)
      return (rV);

   /*************************************************************************/
   /* Set pointers to information.  If this is not a matrix UDF scram       */
   /*************************************************************************/

   ex = ginfo.expt;
   pTr = ex->info_ptr;
   if (ex->smp_id == 3)
      return (NOT_MATRIX_UDF);

   /*************************************************************************/
   /* Initial setups                                                        */
   /*************************************************************************/

   ColN = 0;
   ExDa = (struct idf_data *) UDF;
   Md->BYr = 0;

   /*************************************************************************/
   /* Begin the loop over the matrix columns                                */
   /*************************************************************************/

   do
   {

   /*************************************************************************/
   /* Read the data                                                         */
   /*************************************************************************/

      rV = read_drec (KeY, Ex, vN, UDF, SeN, ColN, 0, 0);

   /*************************************************************************/
   /* If first column then check here if the matrix array is up to snuff    */
   /*************************************************************************/

      if (ColN == 0)
      {
         Md->TCols = *pTr->TOT_COLS;
         Md->TRows = ExDa->num_sample;
         TBytes = Md->TCols * Md->TRows * sizeof(ReaL_4);
         LastCN = Md->TCols - 1;
         if (Md->Sz >= TBytes)
         {
            if ((Md->Data = realloc (Md->Data, TBytes)) == 0) 
               return (-331);
            Md->Sz = TBytes;
         }
      }

   /*************************************************************************/
   /* Convert the data and load it into the matrix. Pointer f1 is set to    */
   /* to the matrix column being loaded.  Matrix is a linear array of       */
   /* columns of data.                                                      */
   /*************************************************************************/

      if (rV == ALL_OKAY || ExDa->filled_data)
      {
         f1 = (ReaL_4 *)Md->Data + ColN * Md->TRows;
         rV = convert_to_units (KeY, Ex, vN, UDF, SENSOR, 0, Md->NAS, 
                                Md->Tbls, Md->Ops,  f1, 0, 0L);
         if (rV != ALL_OKAY)
            return (rV);

   /*************************************************************************/
   /* Set the time - beginning time is the time of first column filled and  */
   /* ending time is the time of the last column                            */
   /*************************************************************************/

         if (Md->BYr == 0)
         {
            Md->BYr = ExDa->byear;
            Md->BDy = ExDa->bday;
            Md->BMs = ExDa->bmilli;
            Md->BNs = ExDa->bnano;
         }

         Md->EYr = ExDa->eyear;
         Md->EDy = ExDa->eday;
         Md->EMs = ExDa->emilli;
         Md->ENs = ExDa->enano;
      }

   /*************************************************************************/
   /* Increment the column number                                           */
   /*************************************************************************/
     
   } while (++ColN <= LastCN);

   if (FwD == 1)
      rV = read_drec (KeY, Ex, vN, UDF, SeN, 0, 1, 0);

   return (ALL_OKAY);
}
