#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                            IR_TO_SIGN SUBROUTINE                            *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine will takes an array of sensor data return its "signed"      * *    value.  If the sign bit is not set, nothing ocurs.  However, if the      *
 *    the sign bit is set, the signed quantity is replaced in the data array.  *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    long *dAtA                 the data array                                *
 *    long Nele                  the length of the data array                  *
 *    char TdwLen                the word length of the data values (in bits)  *
 *                                                                             *
 *  USAGE                                                                      *
 *    x = ir_to_sign (dAtA, Nele, TdwLen)                                      *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    long  *l1                    pointer to data values                      *
 *    long  *lEnD                  end of data array                           *
 *    long result                  value used to convert to a signed value     *
 *    long max_ele                 the largest positive value for this TdwLen  *
 *    long mask                    masking value to catch the sign bit         *
 *    char sgn                     flag indicating if the sign bit is set      *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void ir_to_sign (ByTe_4 *dAtA, u_ByTe_2 Nele, ByTe_1 TdwLen)
{
   register ByTe_4 *l1, *lEnD;
   ByTe_4 result = -1, max_ele, mask;
   ByTe_1 sgn;

   if (TdwLen == 32)                          /* full word length?           */
      return;                                 /* sign bit is already set     */

   mask = 1 << (TdwLen - 1);                  /* set sign bit mask           */
   max_ele = (1 << TdwLen) - 1;               /* maximum unsigned value      */

   l1 = dAtA;                                 /* pointer to data             */
   lEnD = l1 + Nele;                          /* end of data                 */
   for ( ; l1 < lEnD; ++l1)                   /* loop over data              */
   {                                          /* BEGIN DATA LOOP             */
      sgn = (*l1 & mask) >> (TdwLen - 1);     /* get sign bit                */
      if (sgn == 1)                           /* data should be signed?      */
        *l1 = (result - max_ele) + *l1;       /* make it so                  */
   }                                          /* END DATA LOOP               */
}
