#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <stdlib.h>
#include "util_str.h"
#include "user_defs.h"
#include "gen_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                         INIT_VIDF SUBROUTINE                               *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine is called to indicate how information from the VIDF file   *
 *  is to be accessed, that is, held in memory or read from disk for each     *
 *  element.                                                                  *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    unsigned long Key            key which uniquely identifies the data set *
 *                                 being processed                            *
 *    char *exten                  filename extension for the data to be used *
 *    unsigned short vN            version number to be associated with this  *
 *                                 combination (allows for multiple opens)    *
 *    char type                    flag indicating how the VIDF info is to be *
 *                                 accessed                                   *
 *                                                                            *
 *  USAGE                                                                     *
 *    x = init_vidf (Key, exten, vN, type)                                    *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    ir_locate_ex()               determines if requested UDF definition has *
 *                                 already been processed and points to the   *
 *                                 correct structure allocated for the combo  *
 *    lseek()                      positions the file pointer within the file *
 *    read()                       reads N bytes from the file associated     *
 *                                 with the file descriptor given             *
 *    malloc()                     allocates memory                           *
 *    free ()                      frees previously allocated memory          *
 *    strncmp ()                   compares two strings byte-by-byte up to a  *
 *                                 maximum number of bytes                    *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    struct general_info          structure holding information concerning   *
 *         ginfo                   the experiment that is being processed     *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct experiment_info *ex   a pointer to the structure that holds      *
 *                                 specific experiment information            *
 *    long bytes                   the number of bytes to read/lseek          *
 *    short rval                   holds value returned by called module      *
 *    char reset_called            flag indicating if LOCATE_EX was called    *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

ByTe_4 init_vidf (u_ByTe_4 Key, ByTe_1 *exten, u_ByTe_2 vN, ByTe_1 type)
{
   extern struct general_info ginfo;
   extern ByTe_1 BswaP;

   struct experiment_info *ex;
   ByTe_4 bytes, rV, L;
   ByTe_2 rval;
   ByTe_1 reset_called;

  /***********************************************************************/
  /*  Set a pointer to the structure which holds all information that is */
  /*  pertinent to the experiment currently being processed.             */ 
  /***********************************************************************/

   if (!ginfo.called_locate) {
      rval = ir_locate_ex (Key, exten, vN, 0);
      if (rval != ALL_OKAY) { return (INIT_VIDF_NOT_FOUND); }
 
      ginfo.called_locate = 1;
      reset_called = 1;
   } else { reset_called = 0; }

   ex = ginfo.expt;

  /***********************************************************************/
  /*  The VIDF information has not been loaded yet. Read the version     */
  /***********************************************************************/

   if (ex->VIDF_INFO.info_off == 0) {
      ex->VIDF_INFO.info_off += 8;
      rV = lseek (ex->fdi, 0, SEEK_SET);
      read (ex->fdi, (ByTe_1 *) ex->VIDF_INFO.version, 8);
      ex->VIDF_INFO.version[8] = 0;

  /***********************************************************************/
  /*  Second character is an I if this is a new fangled SwRI VIDF.  They */
  /*  now have a "general ancillary" definition but the lengths still    */
  /*  are not independent.  Need to know this later                      */
  /***********************************************************************/

      if (ex->VIDF_INFO.version[1] == 'I')
         ex->VIDFver = -atof(&ex->VIDF_INFO.version[2]);
      else 
         ex->VIDFver = atof(&ex->VIDF_INFO.version[1]);

      if (abs(ex->VIDFver) > 2.201) {
        return (INIT_VIDF_BAD_VERSION);
      } else {
         read (ex->fdi, (ByTe_1 *) &bytes, 4);
         if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&bytes, 1);
         ex->VIDF_INFO.info_off += bytes + 4;
         read (ex->fdi, (ByTe_1 *) ex->VIDF_INFO.offsets, bytes);
         L = bytes / 4;
         if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&ex->VIDF_INFO.offsets, L);
         read (ex->fdi, (ByTe_1 *) &ex->VIDF_INFO.TABLES, 4);
         if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&ex->VIDF_INFO.TABLES, 1);
         ex->VIDF_INFO.info_off += 4;
         read (ex->fdi, (ByTe_1 *) &bytes, 4);
         if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&bytes, 1);
         if ((ex->VIDF_INFO.tbl_offs = malloc (bytes)) == NO_MEMORY) {
            return (INIT_VIDF_TBL_MALLOC);
         } else {
            ex->VIDF_INFO.info_off += bytes + 4;
            read (ex->fdi, (ByTe_1 *) ex->VIDF_INFO.tbl_offs, bytes);
            L = bytes / 4;
            if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)ex->VIDF_INFO.tbl_offs, L);
            read (ex->fdi, (ByTe_1 *) &ex->VIDF_INFO.CONSTS, 4);
            if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&ex->VIDF_INFO.CONSTS, 1);
            ex->VIDF_INFO.info_off += 4;
            read (ex->fdi, (ByTe_1 *) &bytes, 4);
            if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&bytes, 1);
            if ((ex->VIDF_INFO.const_offs = malloc (bytes)) == NO_MEMORY) {
               return (INIT_VIDF_CONST_MALLOC);
            } else {
               ex->VIDF_INFO.info_off += bytes + 4;
               read (ex->fdi, (ByTe_1 *) ex->VIDF_INFO.const_offs, bytes);
               L = bytes / 4;
               if(BswaP) 
                   ReOrderBytes(4, (u_ByTe_1 *)ex->VIDF_INFO.const_offs, L);
               ex->VIDF_INFO.info_off += 4;
             }
          }
      }
   }

   if ((type == VIDF_FROM_MEMORY) && (ex->VIDF_INFO.vidf_data == NO_MEMORY))
    {
/*
      rV = lseek (ex->fdi, 0, ex->VIDF_INFO.info_off);
*/
      read (ex->fdi, (ByTe_1 *) &bytes, 4);
              
      /************************************************************/
      /*  If a fatal error occurred, no need for error code;      */
      /*  future access will be from disk not memory.             */ 
      /************************************************************/

      if(BswaP) ReOrderBytes(4, (u_ByTe_1 *)&bytes, 1);
      if ((ex->VIDF_INFO.vidf_data = malloc (bytes)) != NO_MEMORY)
          read (ex->fdi, (ByTe_1 *) ex->VIDF_INFO.vidf_data, bytes);
    }
   else if (type == VIDF_FROM_DISC)
    {
      if (ex->VIDF_INFO.vidf_data != NO_MEMORY)
       {
           free (ex->VIDF_INFO.vidf_data);
           ex->VIDF_INFO.vidf_data = NO_MEMORY;
       }
    }
    
  if (reset_called)
    ginfo.called_locate = 0;

  return (ALL_OKAY);
}
