#include <stdio.h>
#include <stdlib.h>
#include "util_str.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*****************************************************************************
 *                                                                           *
 *                         IR_FREE_IDF_DATA_PTR SUBROUTINE                   *
 *                                                                           *
 *  DESCRIPTION                                                              *
 *    This routine is called to free all memory that is associated with the  *
 *  data structure being referenced.                                         *
 *                                                                           *
 *  INPUT VARIABLES                                                          *
 *    void *idf_data_ptr       ptr to memory location for the structure that *
 *                             holds returned data values (read_drec)        *
 *                                                                           *
 *  USAGE                                                                    *
 *    ir_free_idf_data_ptr (idf_data_ptr)                                    *
 *                                                                           *
 *  NECESSARY SUBPROGRAMS                                                    *
 *    free ()                  frees previously allocated memory             *
 *                                                                           *
 *  EXTERNAL VARIABLES                                                       *
 *    None                                                                   *
 *                                                                           *
 *  INTERNAL VARIABLES                                                       *
 *    struct idf_data          structure that holds all of the currently     *
 *       *EXP_DATA             returned data values to be processed          *
 *                                                                           *
 *  SUBSYSTEM                                                                *
 *    Display Level                                                          *
 *                                                                           *
 * CHANGES:                                                                  *
 *   07/12/2006 - gurgiolo - add changes to individually delete EXP_DATA     *
 *                data structures.                                           *
 *                                                                           *
 ****************************************************************************/

void ir_free_idf_data_ptr (void *idf_data_ptr)
{
  extern struct general_info ginfo;
  struct idf_data *EXP_DATA;
  register ByTe_4 I;
  ByTe_4 Pos;

  /*************************************************************************/
  /*  Free the memory allocated for the sensor data, calibration data,     */
  /*  sample sequence values, azimuthal start and stop angles and          */
  /*  instrument mode flags that are returned to the user.                 */
  /*************************************************************************/

  if (idf_data_ptr == NO_MEMORY) { return; }

  EXP_DATA = (struct idf_data *) idf_data_ptr;

  Pos = -1;
  for ( I = 0; I < ginfo.num_idf_data_ptr; ++I) {
     if (idf_data_ptr == *(ginfo.idf_data_ptr + I) ) { Pos = I; break; }
  }

  if (EXP_DATA->base_data != NO_MEMORY)
   {
     free (EXP_DATA->base_data);
     EXP_DATA->base_data = NO_MEMORY;
     EXP_DATA->sen_data = NO_MEMORY;
   }

  if (EXP_DATA->base_cal != NO_MEMORY)
   {
     free (EXP_DATA->base_cal);
     EXP_DATA->base_cal = NO_MEMORY;
     EXP_DATA->cal_data = NO_MEMORY;
   }

  if (EXP_DATA->base_swp != NO_MEMORY)
   {
     free (EXP_DATA->base_swp);
     EXP_DATA->base_swp = NO_MEMORY;
     EXP_DATA->swp_data = NO_MEMORY;
   }

  if (EXP_DATA->base_angle != NO_MEMORY)
   {
     free (EXP_DATA->base_angle);
     EXP_DATA->base_angle = NO_MEMORY;
     EXP_DATA->start_az = NO_MEMORY;
     EXP_DATA->stop_az = NO_MEMORY;
   }

  if (EXP_DATA->base_pitch != NO_MEMORY)
   {
     free (EXP_DATA->base_pitch);
     EXP_DATA->base_pitch = NO_MEMORY;
     EXP_DATA->pitch_angles = NO_MEMORY;
   }

  if (EXP_DATA->base_mode != NO_MEMORY) {
     free (EXP_DATA->base_mode);
     EXP_DATA->base_mode = NO_MEMORY;
     EXP_DATA->mode = NO_MEMORY;
  }

  if (EXP_DATA->base_cset != NO_MEMORY)
   {
     free (EXP_DATA->base_cset);
     EXP_DATA->base_cset = NO_MEMORY;
     EXP_DATA->cset_num = NO_MEMORY;
   }

   if ( Pos >= 0 ) {
      free (*(ginfo.idf_data_ptr + Pos));
      *(ginfo.idf_data_ptr + Pos) = NO_MEMORY;
   }
}
