#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                           FIELDS_TO_KEY SUBROUTINE                          *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine creates a key value which identifies the data set of        *
 *  interest.  This key value is used by the other generic utility routines to *
 *  identify the data set.                                                     *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    short *params                pointer to the project, mission, experiment,*
 *                                 instrument and virtual instrument values    *
 *    unsigned long new_key        key which uniquely identifies the data set  *
 *                                 being processed                             *
 *                                                                             *
 *  USAGE                                                                      *
 *    fields_to_key (params, &new_key)                                         *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    short project                the project value                           *
 *    short mission                the mission value                           *
 *    short exper                  the experiment value                        *
 *    short inst                   the instrument value                        *
 *    short vinst                  the virtual instrument value                *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void fields_to_key (ByTe_2 *params, u_ByTe_4 *new_key)
{
    ByTe_2 project, mission, exper, inst, vinst;

    project = *(params);
    mission = *(params + 1);
    exper = *(params + 2);
    inst = *(params + 3);
    vinst = *(params + 4);

    /***********************************************************************/
    /*  The values used in the equation are explained as follows:          */
    /*     128 (2^7) for INSTRUMENTS since field starts at bit 7           */
    /*     8192 (2^13) for EXPERIMENTS since field starts at bit 13        */
    /*     524288 (2^19) for MISSIONS since field starts at bit 19         */
    /*     8388608 (2^23) for PROJECTS since field starts at bit 23        */
    /***********************************************************************/

    *new_key = project * 8388608 + mission * 524288 + exper * 8192 + 
               inst * 128 + vinst;
}
