#include "OpSySInD.h"
#include <stdio.h>
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

ByTe_2 ReOpenFile (u_ByTe_4 KeY, ByTe_1 *EX, u_ByTe_2 VeR, void *UDF,
                   ByTe_2 bY, ByTe_2 bD, ByTe_4 bS, ByTe_4 bN,
                   ByTe_2 eY, ByTe_2 eD, ByTe_4 eS, ByTe_4 eN, ByTe_2 Rv)
{
   ByTe_4 nS, nN;
   ByTe_2 nY, nD;
   ByTe_1 fPos = 0;

/*****************************************************************************/
/*  Check for request to use FilePosRec as positioning routine               */
/*****************************************************************************/

   if (eY < 0) {
      fPos = 1;
      eY = -eY;
   }

/*****************************************************************************/
/*  Do immediate check to see if we even need to open another file           */
/*****************************************************************************/

   if (Rv == LOS_STATUS || Rv == NEXT_FILE_STATUS || Rv == FILE_BACK_UP) {

/*****************************************************************************/
/*  OK - so we have to open another file.  If the user passes in a begin     */
/*  year of 0 then routine will determine the new start time, otherwise      */
/*  use the beginning time passed in.                                        */
/*****************************************************************************/

      if (bY == 0) {
         Rv = next_file_start_time (KeY, EX, VeR, 0, &nY, &nD, &nS, &nN);
         if (Rv != ALL_OKAY)
            return (Rv);
      } else {
         nY = bY;
         nD = bD;
         nS = bS;
         nN = bN;
      }

/*****************************************************************************/
/* Open the file containing the start time                                   */
/*****************************************************************************/

      Rv = reset_experiment_info (KeY, EX, VeR, nY, nD, nS, nN,
                                                eY, eD, eS, eN);

/*****************************************************************************/
/* If we can open it then position to start time, otherwise return the error */
/* code encountered but only if a killer error (< 0).  If not killer error   */
/* then probably just ran out of data - so issue an EOF                      */
/*****************************************************************************/

      if (Rv == ALL_OKAY) {
         if (fPos == 0)
           Rv = file_pos (KeY, EX, VeR, UDF, nY, nD, nS, nN, eY, eD, eS, eN);
         else
           Rv = FilePosRec (KeY, EX, VeR, UDF, nY, nD, nS, nN, eY, eD, eS, eN);
      }
      else
         if (Rv >= 0)
            Rv = EOF_STATUS;
   }

   return (Rv);
}
