#include <stdio.h>
#include "ByteDefs.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                         FILELENGTH SUBROUTINE                              *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine returns the length of a file.  The routine is used         *
 *    rather than the UNIX stat because this is at present a non-ancii call   *
 *    which under LINUX is causing problems when the UDF software is bundled  *
 *    into a dynamically linked library.                                      *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    ByTe_1 *FName         file name of file to obtain length of             *
 *    ByTe_1 *FLength       byte length of the file                           *
 *                                                                            *
 *  USAGE                                                                     *
 *    x = FileLength (FName, &FLength)                                        *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    fopen()                      System Call                                *
 *    fseek()                      System Call                                *
 *    ftell()                      System Call                                *
 *    fclose()                     System Call                                *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    None                                                                    *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    File *fp                     pointer to open file                       *
 *    ByTe_4 Len                   file length                                *
 *    ByTe_2 ECode                 Error Code                                 *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

ByTe_2 FileLength( ByTe_1 *FName, ByTe_4 *FLength)
{
  FILE* fp;
  ByTe_4 Len;
  ByTe_2 ECode;

  *FLength = -1;                                      /* default file length */
  if ((fp = fopen( FName, "rb" ) ) == NULL )          /* open file           */
     return -1;                                       /* and get out         */

  fseek( fp, 0L, SEEK_END);                           /* seek to the end     */
  if ( (Len = ftell(fp)) >= 0L)                       /* get file length     */
  {                                                   /* BEG SUCCESS         */
     *FLength = Len;                                  /* set output file len */
     ECode = 0;                                       /* no errors           */
  }                                                   /* END SUCCESS         */
  else                                                /* no length           */
    ECode = -2;                                       /* zero byte error     */

  if (fclose(fp) != 0 )                               /* close the file      */
    return -3;                                        /* close error         */

  return ECode;
}
