#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

ByTe_2 BuildImage (u_ByTe_4 KeY, ByTe_1 *Ex, u_ByTe_2 vN, void *UDF, 
                    struct MatrixData *Md, ByTe_1 Storage)
{
   extern struct general_info ginfo;
   struct idf_data  *ExDa;
   struct experiment_info *ex;
   struct ptr_rec *pTr; 

   register ByTe_4 I, J;
   register ReaL_4 *f1, *f2, *fEnD;

   size_t TBytes;
   ByTe_4 ImagePixels;
   ByTe_4 NPlns, LRd, CCol = 0, CRow, NRds;

   ByTe_2 rV, cN = 0, sN = -1;
   ByTe_1 FwD;

   /*************************************************************************/
   /*  Locate the information associated with the Key to be used            */
   /*************************************************************************/

   rV = ir_locate_ex (KeY, Ex, vN, 0); 
   if (rV != ALL_OKAY)
      return (rV);

   /*************************************************************************/
   /* Set pointers to information.                                          */
   /*************************************************************************/

   ex = ginfo.expt;
   pTr = ex->info_ptr;

   /*************************************************************************/
   /* Initial setups                                                        */
   /*************************************************************************/

   ExDa = (struct idf_data *) UDF;
   Md->BYr = 0;

   /*************************************************************************/
   /* Blind read to see if we are at the start of a data record and also to */
   /* get some of the initial parameters                                    */
   /*************************************************************************/

   if ((rV = read_drec (KeY, Ex, vN, UDF, sN, cN, 0, 0)) != ALL_OKAY)
      return (rV);

   /*************************************************************************/
   /* if not at the first sensor set then not a beginning of a record. Need */
   /* to make this true otherwise we will be mixing images                  */ 
   /*************************************************************************/

   if (pTr->cur_sen_set != 0)
   {
       do
       {
          if ((rV = read_drec (KeY, Ex, vN, UDF, sN, cN, 1, 0)) != ALL_OKAY)
             return (rV);
       } while (pTr->cur_sen_set != 0);
   }

   /*************************************************************************/
   /* Save the number of rows and columns in the image and the number of    */
   /* image planes.  This depends on Storage.                               */
   /*                                                                       */
   /* Storage = 0.  Each sensor is a pixel and each array element under the */
   /*               sensor is data from one image plane                     */
   /* Storage = 1.  Each sensor is a column in an image and each array      */
   /*               element under the sensor is a row in the image.         */
   /*               Separate sensors are separate images.                   */
   /*************************************************************************/

   Md->TCols = (*pTr->NSS > 0) ? *pTr->NSS : -(*pTr->NSS);
   if (Storage == 0)
   {
      Md->TRows = *pTr->N_SEN;
      NPlns = *pTr->N_SAMPLE;
      ImagePixels = Md->TRows * Md->TCols;
      NRds = Md->TRows;
      LRd = Md->TRows - 1;
   }
   else
   {
      NPlns = *pTr->N_SEN;
      Md->TRows = *pTr->N_SAMPLE;
      ImagePixels = Md->TRows * Md->TCols;
      NRds = NPlns;
      LRd = NPlns - 1;
   }

   /*************************************************************************/
   /* Get space for the images.                                             */
   /*************************************************************************/

   TBytes = (ImagePixels * NPlns + NPlns) * sizeof(ReaL_4);
   if (Md->Sz < TBytes)
   {
      if ((Md->Data = realloc (Md->Data, TBytes)) == 0) 
         return (MALLOC_ERROR);
      Md->Sz = TBytes;
   }
   fEnD = (ReaL_4 *)Md->Data + ImagePixels * NPlns + NPlns;

   /*************************************************************************/
   /* Begin the loop over the images                                        */
   /*************************************************************************/

   for (J = 0; J < Md->TCols; ++J)
   {

   /*************************************************************************/
   /* Read one columns worth of data.  Forward on the last Pixel in the row */
   /*************************************************************************/

      CRow = 0;
      for (I = 0; I < NRds; ++I, ++CRow)
      {
         FwD = (I == LRd) ? 1 : 0;
         sN = *(pTr->SENSOR_INDEX + I);
          if ((rV = read_drec (KeY, Ex, vN, UDF, sN, cN, FwD, 0)) < 0)
             return (rV);

   /*************************************************************************/
   /* Convert the data and load it into the image data array. Note that     */
   /* images are loaded plane by plane and within an image column by column */
   /*************************************************************************/

          if (rV == ALL_OKAY || ExDa->filled_data)
          {
              if (Storage == 0)
                 f1 = (ReaL_4 *)Md->Data + ImagePixels * NPlns;
              else
                 f1 = (ReaL_4 *)Md->Data + ImagePixels * I + Md->TRows * CCol;

              rV = convert_to_units (KeY, Ex, vN, UDF, SENSOR, 0, Md->NAS, 
                                     Md->Tbls, Md->Ops,  f1, 0, 0L);
              if (rV != ALL_OKAY)
                 return (rV);

              if (Storage == 0)
              {
                 f2 = (ReaL_4 *)Md->Data + CCol * Md->TRows + CRow;
                 for ( ; f2 < fEnD; f2 += ImagePixels)
                   *f2 = *f1++;
              }
          }

          if (Md->BYr == 0)
          {
             Md->BYr = ExDa->byear;
             Md->BDy = ExDa->bday;
             Md->BMs = ExDa->bmilli;
             Md->BNs = ExDa->bnano;
          }

          Md->EYr = ExDa->eyear;
          Md->EDy = ExDa->eday;
          Md->EMs = ExDa->emilli;
          Md->ENs = ExDa->enano;
       }
       ++CCol;

   } 

   return (ALL_OKAY);
}
