#include "util_str.h"
#include "ret_codes.h"
#include "libbase_udf.h"

/*****************************************************************************
 *                                                                           *
 *                        READ_IDF SUBROUTINE                                *
 *                                                                           *
 *  DESCRIPTION                                                              *
 *    This routine is called to retrieve information from the VIDF definition*
 *  file for the data set specified.  The information is either retrieved    *
 *  from the VIDF definition file on disk (slow method) or from the memory   *
 *  that was allocated to hold the VIDF data (fast method).  If an error     *
 *  condition was encountered when setting up the fast method, conditions    *
 *  are reset to indicate slow access if the user wishes to ignore the error *
 *  code returned.                                                           *
 *                                                                           *
 *  INPUT VARIABLES                                                          *
 *    unsigned long data_key      key which uniquely identifies the data set *
 *                                being processed                            *
 *    char *exten                 filename extension for the data to be used *
 *    unsigned short vnum         version number to be associated with this  *
 *                                combination (allows for multiple opens)    *
 *    char *var                   output value(s) associated with selected   *
 *                                field                                      *
 *    short quan                  specified field in VIDF file               *
 *    short num                   the table or constant definition from      *
 *                                which the required field is to be retrieved*
 *    short len                   if the selected field is an array, this is *
 *                                the number of elements to be returned      *
 *    long start                  if the selected field is an array, this is *
 *                                the starting position in the array         *
 *                                                                           *
 *  USAGE                                                                    *
 *    x = read_idf (data_key, exten, vnum, &var, quan, num, start, len)      *
 *                                                                           *
 *  NECESSARY SUBPROGRAMS                                                    *
 *    ir_locate_ex()              determines if the requested combination has*
 *                                already been processed and points to the   *
 *                                correct structure allocated for the combo  *
 *    ir_read_idf_disk ()         access the VIDF information from the file  *
 *                                located on disk                            *
 *    ir_read_idf_memory ()       access the VIDF information from the memory*
 *                                that was allocated to hold the data        *
 *                                                                           *
 *  EXTERNAL VARIABLES                                                       *
 *    struct general_info         structure that holds information concerning*
 *         ginfo                  the experiment that is being processed     *
 *                                                                           *
 *  INTERNAL VARIABLES                                                       *
 *    struct experiment_info      a pointer to the structure that holds      *
 *            *ex                 specific experiment information            *
 *    long rV                     the value returned by the called routine   *
 *    short rval                  the value returned by the called routine   *
 *                                                                           *
 *  SUBSYSTEM                                                                *
 *    Display Level                                                          *
 *                                                                           *
 ****************************************************************************/

ByTe_4 read_idf (u_ByTe_4 data_key, ByTe_1 *exten, u_ByTe_2 vnum, 
                 ByTe_1 *var, ByTe_2 quan, ByTe_2 num, ByTe_4 start, 
                 ByTe_2 len)
{
    extern struct general_info ginfo;

    struct experiment_info *ex;
    ByTe_4 rV;
    ByTe_2 rval;

    /***********************************************************************/
    /*  Set a pointer to the structure which holds all information that is */
    /*  pertinent to the data set currently being processed.               */
    /***********************************************************************/
  
    if (!ginfo.called_locate)
     {
       rval = ir_locate_ex (data_key, exten, vnum, 0);
       if (rval != ALL_OKAY)
         return (IDF_NOT_FOUND);
     }

    /****************************************************************/
    /*  Read the VIDF information from the disk or from memory?     */
    /****************************************************************/

    ex = ginfo.expt;
    if (ex->VIDF_INFO.vidf_data == 0)
       rV = ir_read_idf_disk (var, quan, num, start, len);
    else
       rV = ir_read_idf_memory (var, quan, num, start, len);
    return (rV);
}
