#include "util_str.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                          IR_INIT_STRUCT SUBROUTINE                          *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine is called to initialize the internal structure which        *
 *  indicates how many experiment_info structures have been allocated.         *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    None                                                                     *
 *                                                                             *
 *  USAGE                                                                      *
 *    ir_init_struct ()                                                        *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    struct general_info ginfo    structure that holds information concerning *
 *                                 the experiment that is being processed      *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void ir_init_struct (void)
{
   extern struct general_info ginfo;

   /************************************************************************/
   /*  Initialize the internal structure used to control the processing of */
   /*  information for the various data sets.                              */
   /************************************************************************/

   ginfo.nds = 0;
   ginfo.pos_ex = 0;
   ginfo.exbase = NO_MEMORY;
   ginfo.expt = NO_MEMORY;
   ginfo.sexper = 0;
   ginfo.mexper = NO_MEMORY;
   ginfo.called_locate = 0;
   ginfo.next_version = 0;
   ginfo.idf_data_ptr = NO_MEMORY;
   ginfo.num_idf_data_ptr = 0;
}
