#include "LinkList.h"
#include "StrHier.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

/*******************************************************************************
 *                                                                             *
 *                           GET_DATA_KEY SUBROUTINE                           *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine creates a key value which identifies the data set of        *
 *  interest by using assigned database names.  This key value is used by the  *
 *  other generic utility routines to identify the data set.                   *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    char *pstr                   name of the project                         *
 *    char *mstr                   name of the mission                         *
 *    char *estr                   name of the experiment                      *
 *    char *istr                   name of the instrument                      *
 *    char *vstr                   name of the virtual instrument              *
 *    unsigned long *data_key      key which uniquely identifies the data set  *
 *                                 being processed                             *
 *                                                                             *
 *  USAGE                                                                      *
 *    x = get_data_key (pstr, mstr, estr, istr, vstr, &data_key);              *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    SourceByStr ()               searches the configuration information for  *
 *                                 the requested data level                    *
 *    SNUM ()                      returns the database assigned value         *
 *    fields_to_key ()             returns the data key based upon database    *
 *                                 assigned numbers                            *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    extern LinkList Projects     pointer to current configuration info       *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    StrHier Scode                holds values returned by called module      *
 *    short project                the project value                           *
 *    short mission                the mission value                           *
 *    short exper                  the experiment value                        *
 *    short inst                   the instrument value                        *
 *    short vinst                  the virtual instrument value                *
 *    short params[]               array which holds the project, mission,     *
 *                                 experiment, inst and virtual inst values    *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

ByTe_2 get_data_key (ByTe_1 *pstr, ByTe_1 *mstr, ByTe_1 *estr, ByTe_1 *istr, 
                     ByTe_1 *vstr, u_ByTe_4 *data_key)
{
   extern LinkList Projects;

   StrHier Scode;
   ByTe_2 project, mission, exper, inst, vinst, params[5];

   /*********************************************************************/
   /*  Get the assigned database number for the project.                */
   /*********************************************************************/

   Scode = SourceByStr (Projects, pstr, (ByTe_1 *) 0); 
   if (Scode == NULL)
     return (DKEY_PROJECT);
   else
     project = SNUM (Scode);

   /*********************************************************************/
   /*  Get the assigned database number for the mission.                */
   /*********************************************************************/

   Scode = SourceByStr (Projects, pstr, mstr, (ByTe_1 *) 0); 
   if (Scode == NULL)
     return (DKEY_MISSION);
   else
     mission = SNUM (Scode);

   /*********************************************************************/
   /*  Get the assigned database number for the experiment.             */
   /*********************************************************************/

   Scode = SourceByStr (Projects, pstr, mstr, estr, (ByTe_1 *) 0); 
   if (Scode == NULL)
     return (DKEY_EXPERIMENT);
   else
     exper = SNUM (Scode);

   /*********************************************************************/
   /*  Get the assigned database number for the instrument.             */
   /*********************************************************************/

   Scode = SourceByStr (Projects, pstr, mstr, estr, istr, (ByTe_1 *) 0);
   if (Scode == NULL)
     return (DKEY_INSTRUMENT);
   else
     inst = SNUM (Scode);

   /*********************************************************************/
   /*  Get the assigned database number for the virtual instrument.     */
   /*********************************************************************/

   Scode = SourceByStr (Projects, pstr, mstr, estr, istr, vstr, (ByTe_1 *) 0); 
   if (Scode == NULL)
     return (DKEY_VINST);
   else
     vinst = SNUM (Scode);

   /*********************************************************************/
   /*  Get the data key value.                                          */
   /*********************************************************************/

   params[0] = project;
   params[1] = mission;
   params[2] = exper;
   params[3] = inst;
   params[4] = vinst;
   fields_to_key (params, data_key);
   return (ALL_OKAY);
}
