#include <stdlib.h>
#include "OpSySInD.h"
#include "util_str.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                         IR_FREE_VIDF_STRUCTURE SUBROUTINE                   *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine is called to free all allocated memory associated with the  *
 *  reading of the VIDF information from memory as opposed to from the disk.   *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    struct experiment_info   a pointer to the structure that holds specific  *
 *          *ex                experiment information                          *
 *                                                                             *
 *  USAGE                                                                      *
 *    ir_free_vidf_structure (ex)                                              *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    free ()                  frees previously allocated memory               *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    register short i         looping variable                                *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void ir_free_vidf_structure (struct experiment_info  *ex)
{
   register ByTe_2 i;

   if (ex->VIDF_INFO.vidf_data != NO_MEMORY) {
      free (ex->VIDF_INFO.vidf_data);
      ex->VIDF_INFO.vidf_data = NO_MEMORY;
   }

   if (ex->VIDF_INFO.tbl_offs != NO_MEMORY) {
      free (ex->VIDF_INFO.tbl_offs);
      ex->VIDF_INFO.tbl_offs = NO_MEMORY;
   }

   if (ex->VIDF_INFO.const_offs != NO_MEMORY) {
      free (ex->VIDF_INFO.const_offs);
      ex->VIDF_INFO.const_offs = NO_MEMORY;
   }

  /**********************************************************************/
  /*  Reset the rest of the VIDF substructure.                          */
  /**********************************************************************/

   ex->VIDF_INFO.version[0] = '\0';
   ex->VIDF_INFO.info_off = 0;
   ex->VIDF_INFO.TABLES = 0;
   ex->VIDF_INFO.CONSTS = 0;
   for (i = 0; i < 72; ++i) { ex->VIDF_INFO.offsets[i] = 0; }
}
