#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include "util_str.h"
#include "user_defs.h"
#include "gen_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "Server.h"
#include "libCfg.h"
#include "OpSySInD.h"
#include "idf_defs.h"

ByTe_2 NewVidf (void *UDF)
{
   extern struct general_info ginfo;
   extern LinkList Projects;

   struct idf_data *ExDa;
   struct experiment_info *ex;
   struct ptr_rec *ptr;

   void *TmP;
   StrHier DSrc;
   Time_t btm, etm;
   ByTe_4 rV, B, vTm[3];
   ByTe_2 ret_code, params[5];
   ByTe_1 vname[NAME_SIZE];

   ex = ginfo.expt;
   ptr = ex->info_ptr;
   ExDa = (struct idf_data *) UDF;

   /**************************************************************************/
   /*  If the data vidf file is open close it                                */
   /**************************************************************************/

   if (ex->fdi != -1)
   {
      close (ex->fdi);
      ir_free_vidf_structure (ex);
      ex->fdi = -1;
   }

   /**************************************************************************/
   /* get data key and setup source tree                                     */
   /**************************************************************************/

   key_to_fields (ExDa->data_key, params);
   DSrc = SourceByNum (Projects, (ByTe_1 *) params[0], (ByTe_1 *) params[1],
                       (ByTe_1 *) params[2], (ByTe_1 *) params[3], 
                       (ByTe_1 *) params[4], (ByTe_1 *) 0);
   if (DSrc == NULL)
      return (PBACK_BAD_SRC);

   /**************************************************************************/
   /* Begin time is set to data time which caused time to go beyond the      */
   /* current VIDF file                                                      */
   /**************************************************************************/

   btm.yr = *ptr->YEAR;
   btm.day = *ptr->DAYOFYEAR;
   btm.msec = ExDa->bmilli + (ExDa->bnano / 1000000);

   etm.yr = *ptr->YEAR + 1;
   etm.day = 1;
   etm.msec = 0;

   /**************************************************************************/
   /* open the needed VIDF file                                              */
   /**************************************************************************/

   rV = pbr (btm, etm, DSrc, _VIDF, ExDa->exten, vname, vTm);

   if (rV < 0)
      return (rV);

   if (rV == NO_DATA)
        return (NO_DATA);
   else if (rV == NO_DATA_AOS)
        return (NO_DATA_AOS);
   else if (rV == RETRIEVING)
        return (RETRIEVING);

   if (rV == RETRIEVING_DATA)
      ret_code = RETRIEVING_DATA;
   else
      ret_code = ALL_OKAY;

   strcpy (ex->idf_name, vname);
   if ((ex->fdi = open (vname, O_RDONLY)) < 0)
     return (PBACK_NO_VIDF);

#ifdef _CyGnUsC
      setmode (ex->fdi, O_BINARY);
#endif
#ifdef WIN32
      _setmode (ex->fdi, O_BINARY);
#endif

   /**************************************************************************/
   /* read in the VIDF file                                                  */
   /**************************************************************************/

   rV = init_vidf (ex->data_key, ex->exten, ex->version, VIDF_FROM_MEMORY);
   if (rV < 0)
   {
      ir_free_vidf_structure (ex);
      return ((ByTe_2) rV);
   }

   /**************************************************************************/
   /* save the last data record read                                         */
   /**************************************************************************/

   B = 4 * (ptr->d_size / 4 + 1);
   if ((TmP = malloc (B)) == NO_MEMORY)
      return (MALLOC_ERROR);
   memcpy (TmP, ex->DATA_MEM, B);

   /**************************************************************************/
   /* do all the VIDF read once stuff - this will free all of the base_data  */
   /* memory so we saved the last data record read above                     */
   /**************************************************************************/

   if ((rV = ir_read_idf_once ()) != ALL_OKAY)
      return ((ByTe_2)rV);

   /**************************************************************************/
   /*  restore the last data record read and free the temp memory            */
   /**************************************************************************/

   memcpy (ex->DATA_MEM, TmP, B);
   free (TmP);

   /**************************************************************************/
   /* Free all of the Tbl and Sensor memory associated with this ex struct   */
   /**************************************************************************/

   FreeTblSen(ex);

   /**************************************************************************/
   /* reload all the sensor info and tables                                  */
   /**************************************************************************/

   if ((rV = ir_sensor_combo ()) != ALL_OKAY)
      return ((ByTe_2)rV);

   if ((rV = ir_get_mode_info ()) != ALL_OKAY)
      return ((ByTe_2)rV);

   return (ret_code);
}
