#include <stdio.h>
#include <stdlib.h>
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "idf_defs.h"
#include "libbase_udf.h"

/*****************************************************************************
 *                                                                           *
 *                              BuildBins  SUBROUTINE                        *
 *                                                                           *
 *  DESCRIPTION                                                              *
 *    This module builds the upper and lower bin edges from a combination    *
 *  of two of the following: upper limit, lower limit, center, full width    *
 *  half maximum of the bin.                                                 *
 *                                                                           *
 *     Off1 and Off2 are the locations of the two constants being passed in  *
 *  and Low and Up and the storage locations of the Upper and Lower Edge.    * 
 *  Id gives information on what Off1 and Off2 point to.  The values are     *
 *                                                                           *
 *         Id                  Off1                   Off2                   *
 *         --              -----------            -----------                *
 *          0                  Lower                   Center                *
 *          1                  Upper                   Center                *
 *          2                  FWHM                    Center                *
 *          3                  Lower                   Upper                 *
 *          4                  Lower                   FWHM                  *
 *          5                  Upper                   FWHM                  *
 *                                                                           *
 *  NOTE:  if both Off1 or Off2 are -1 then this routine will return with    *
 *         no action.  If only Off2 is -1 then this routine will copy what   *
 *         values it finds in the first constant into the second.            * 
 *****************************************************************************/

ByTe_2 BuildBins (ByTe_4 Off1, ByTe_4 Off2, ByTe_4 Low, ByTe_4 Up, ByTe_2 Id)
{
   extern struct general_info ginfo;

   struct experiment_info *ex;
   register ReaL_4 *f1, *f2, *f3, *f4;
   register ByTe_4 I;
   ReaL_4 B, W, T, M; 
   ByTe_4 ComBo;
   ByTe_2 rV = ALL_OKAY;

   ex = ginfo.expt;

   ComBo = (Off1 < 0 && Off2 < 0) ? -1 : (Off2 < 0) ? 6 : Id;
   if (Off1 >= 0)
      f1 = ex->constants + Off1 * ex->num_sensor;
   if (Off2 >= 0)
      f2 = ex->constants + Off2 * ex->num_sensor;
   f3 = ex->constants + Low * ex->num_sensor;
   f4 = ex->constants + Up * ex->num_sensor;
   switch (ComBo)
   {
      case 0:
         for ( I = 0; I < ex->num_sensor; ++I) 
         {
             B = *f1++;
             M = *f2++;
             *f3++ = B;
             *f4++ = 2 * M - B;
         }
      break;
      case 1:
         for ( I = 0; I < ex->num_sensor; ++I) 
         {
             T = *f1++;
             M = *f2++;
             *f3++ = 2 * M - T;
             *f4++ = T;
         }
      break;
      case 2:
         for ( I = 0; I < ex->num_sensor; ++I) 
         {
             W = *f1++;
             M = *f2++;
             *f3++ = M - W/2.0;
             *f4++ = M + W/2.0;
         }
      break;
      case 3:
      break;
      case 4:
         for ( I = 0; I < ex->num_sensor; ++I) 
         {
             B = *f1++;
             W = *f2++;
             *f3++ = B;
             *f4++ = B + W;
         }
      break;
      case 5:
         for ( I = 0; I < ex->num_sensor; ++I) 
         {
             T = *f1++;
             W = *f2++;
             *f3++ = T - W;
             *f4++ = T;
         }
      break;
      case 6:
         for ( I = 0; I < ex->num_sensor; ++I)
             *f4++ = *f1++;
      break;
      case -1:
         rV = 0;
      break;
   }

   return (rV);
}
