;============================================================
; Routine : plot_ENAflux.pro
; Description: Creates the earth image/browse products
;
; Developer       Date     Build       Description
; ---------       ----     -----       -------------------------
; Mei-Ching Fok             0.0        original implementation
; Richard L. West (CSC)                extensive plotting modifications
;
;============================================================

pro plot_ENAflux, image0, image1, image2, l_setup, nadir

;
;------------------------------------------------------------------------------
; plot the data
; l_setup.l_output_type = 1  => 3 12x45 images
; l_setup.l_output_type = 2  => 3 images with earth-sc distance held constant
; l_setup.l_output_type = 3  => 3 12x12 images
;------------------------------------------------------------------------------
;
if (l_setup.l_output_type eq 1) then begin
   plot_3full, l_setup, image0, image1, image2, nadir
endif else if(l_setup.l_output_type eq 2) then begin
   plot_3constant, l_setup, image0, image1, image2, nadir
endif else if(l_setup.l_output_type eq 3) then begin
   plot_3square, l_setup, image0, image1, image2, nadir
endif

;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;

return
end
