;--------------------------------------------------------------------------------
;  
;  Unit Name : l_Interpolate.pro
; 
;  Purpose   : Linear interpolation.
;
;  Return Value:  type = based on input type 
;  Value                         Description
;  -------------------------     ------------------------------
;    y1                          interpolated value 
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;    x0                    *           I        coordinates used for interpolation
;    x1                    *           I        the type for these values 
;    x2                    *           I        depend on the values given to this
;    y0                    *           I        routine from calling function
;    y2                    *           I    
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH              10/00            v1.0           Original implementation
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;--------------------------------------------------------------------------------

FUNCTION l_Interpolate, x0, x1, x2, y0, y2  


y1 = ((y2 - y0) / (x2 - x0)) * (x1 - x0) + y0


RETURN, y1

END
