
;-------------------------------------------------------------------------------
;
;  Unit Name : l_InstData.pro
;
;  Purpose   : Read and plot the instrument state data.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH               06/00          v1.0            Original Implementation
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Function: l_InstData
;  Description:
;    Read and write the Instrument State data to the plot.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  l_hskp                struct        I        hskp data parameters
;  l_pltpos              struct        I        generic plot parameters
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;-------------------------------------------------------------------------------

PRO l_InstData, l_hskp, l_pltpos


  ;-----------------------
  ; tof start cfd level
  ;-----------------------
  start_cfd = (*l_hskp.tof_subsys_configPtr)[*,0]

  ;---------------------------------------------
  ; determine if there is a change in the value
  ; if there is a change, label with *
  ;---------------------------------------------
  st_indx = where (start_cfd ne start_cfd[0], wcnt)
  if wcnt gt 0 then begin
     st_label = strcompress((string(format='(I3)', start_cfd[0]) $
                            + '*'), /remove_all)
  endif else begin
     st_label = strcompress(string(format='(I3)', start_cfd[0]) $
                            , /remove_all)
  endelse

  ;-----------------------
  ; tof stop cfd level
  ;-----------------------
  stop_cfd  = (*l_hskp.tof_subsys_configPtr)[*,1]

  ;---------------------------------------------
  ; determine if there is a change in the value
  ; if there is a change, label with *
  ;---------------------------------------------
  sp_indx = where (stop_cfd ne stop_cfd[0], wcnt)
  if wcnt gt 0 then begin
     sp_label = strcompress((string(format='(I3)', stop_cfd[0]) $
                            + '*'), /remove_all)
  endif else begin
     sp_label = strcompress(string(format='(I3)', stop_cfd[0]) $
                            , /remove_all)
  endelse


  str_cntrl = (*l_hskp.hvps_configPtr)[*,13]
  ;---------------------------------------------
  ; determine if there is a change in the value
  ; if there is a change, label with *
  ;---------------------------------------------
  scv_indx = where (str_cntrl ne str_cntrl[0], wcnt)
  if wcnt gt 0 then begin
     str_cntrl_label = strcompress((string(format='(I3)', $
                              str_cntrl[0]) + '*'), /remove_all)
  endif else begin
     str_cntrl_label = strcompress(string(format='(I3)', $
                                 str_cntrl[0]), $
                                 /remove_all)
  endelse


  mcp_stop_vmon  = (*l_hskp.hvps_vmonsPtr)[*,1] 
  ;---------------------------------------------
  ; determine if there is a change in the value
  ; if there is a change, label with *
  ;---------------------------------------------
  msv_indx = where (mcp_stop_vmon ne mcp_stop_vmon[0], wcnt)
  if wcnt gt 0 then begin
     mcp_stop_vmon_label = strcompress((string(format='(I3)', $
                             mcp_stop_vmon[0]) + '*'), /remove_all)
  endif else begin
     mcp_stop_vmon_label = strcompress(string(format='(I3)', $
                              mcp_stop_vmon[0]), $
                              /remove_all)
  endelse

  ;---------------------------------------------
  ; determine position to write labels
  ;---------------------------------------------

  lb_xpmn = l_pltpos.xpltmn
  lb_xpmx = l_pltpos.xpltmx
  lb_ypmn = l_pltpos.doc_ymn
  lb_ypmx = l_pltpos.doc_ymx

  lb_xdel = 0.25
  lb_ydel = 0.015

  lb_xpos_base = lb_xpmn
  lb_ypos_base = lb_ypmn

  ;---------------------------------------------
  ;  add trailer
  ;---------------------------------------------
  lb_xpos = 0.01
  lb_ypos = lb_ypos_base

  label = 'TOF Start CFD Level: ' + st_label
  xyouts, lb_xpos, lb_ypos, label, $
          size=l_pltpos.sm_font, /NORMAL
  ;lb_ypos = lb_ypos - lb_ydel
  lb_xpos = lb_xpos + lb_xdel 


  lb_xpos = lb_xpos + 0.25
  label = 'TOF Stop CFD Level: ' + sp_label
  xyouts, lb_xpos, lb_ypos, label, $
          size=l_pltpos.sm_font, /NORMAL
  lb_xpos = lb_xpos + lb_xdel
  lb_ypos = lb_ypos - lb_ydel

  lb_xpos = 0.01
  label = 'HVPS Optics Steering Cmd: ' + str_cntrl_label
  xyouts, lb_xpos, lb_ypos, label, $
          size=l_pltpos.sm_font, /NORMAL
  lb_xpos = lb_xpos + lb_xdel + 0.25

  label = 'HVPS MCP Stop VMON: ' + mcp_stop_vmon_label 
  xyouts, lb_xpos, lb_ypos, label, $
          size=l_pltpos.sm_font, /NORMAL
  lb_xpos = lb_xpos + lb_xdel


  l_pltpos.doc_ymn = lb_ypos
  l_pltpos.doc_ymx = lb_ypmx - l_pltpos.yspace

RETURN
END
