;-------------------------------------------------------------------------------
;
;  Unit Name : l_ImageCorrection.pro
;
;  Purpose   : Contains files related to correcting images.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH               03/02          v1.0.8           Original implementation
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_CorrectImages
;  Description: Correct distorted images for the binned and event data.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               03/02           v1.0.8           Original implementation
;-------------------------------------------------------------------------------


PRO l_CorrectImages_PolSecSpn, corrected, nspins

    distorted = corrected 
    corrected = fltarr (12, 45, nspins)

    for sp = 0L, nspins - 1L do begin
       for sec = 0L, 44L do begin
   
          ;--- if polar bin 0 ---
          if (distorted[0,sec,sp] gt 0.0) then begin
             corrected[0,sec,sp] = corrected[0,sec,sp] + distorted[0,sec,sp] * 0.175 
             corrected[1,sec,sp] = corrected[1,sec,sp] + distorted[0,sec,sp] * 0.205 
             corrected[2,sec,sp] = corrected[2,sec,sp] + distorted[0,sec,sp] * 0.241 
             corrected[3,sec,sp] = corrected[3,sec,sp] + distorted[0,sec,sp] * 0.301 
             corrected[4,sec,sp] = corrected[4,sec,sp] + distorted[0,sec,sp] * 0.078 
          endif
    
          ;--- if polar bin 1 ---
          if (distorted[1,sec,sp] gt 0.0) then begin
             corrected[4,sec,sp] = corrected[4,sec,sp] + distorted[1,sec,sp] * 0.262 
             corrected[5,sec,sp] = corrected[5,sec,sp] + distorted[1,sec,sp] * 0.439 
             corrected[6,sec,sp] = corrected[6,sec,sp] + distorted[1,sec,sp] * 0.299
          endif

          ;--- if polar bin 2 ---
          if (distorted[2,sec,sp] gt 0.0) then begin
             corrected[6,sec,sp] = corrected[6,sec,sp] + distorted[2,sec,sp] * 0.238 
             corrected[7,sec,sp] = corrected[7,sec,sp] + distorted[2,sec,sp] * 0.762 
          endif

          ;--- if polar bin 3 ---
          if (distorted[3,sec,sp] gt 0.0) then begin
             corrected[8,sec,sp] = corrected[8,sec,sp] + distorted[3,sec,sp] * 1.  
          endif

          ;--- if polar bin 4 ---
          if (distorted[4,sec,sp] gt 0.0) then begin
             corrected[9,sec,sp] = corrected[9,sec,sp] + distorted[4,sec,sp] * 1. 
          endif

          ;--- if polar bin 5 ---
          if (distorted[5,sec,sp] gt 0.0) then begin
             corrected[9,sec,sp] = corrected[9,sec,sp] + distorted[5,sec,sp] * 0.409  
             corrected[10,sec,sp] = corrected[10,sec,sp] + distorted[5,sec,sp] * 0.591 
          endif

          ;--- if polar bin 6 ---
          if (distorted[6,sec,sp] gt 0.0) then begin
             corrected[10,sec,sp] = corrected[10,sec,sp] + distorted[6,sec,sp] * 1.  
          endif

          ;--- if polar bin 7 ---
          if (distorted[7,sec,sp] gt 0.0) then begin
             corrected[10,sec,sp] = corrected[10,sec,sp] + distorted[7,sec,sp] * 0.753 
             corrected[11,sec,sp] = corrected[11,sec,sp] + distorted[7,sec,sp] * 0.247 
          endif

          ;--- if polar bin 8,9,10,11 ---
          sum = distorted[8,sec,sp] + distorted[9,sec,sp] + distorted[10,sec,sp] + distorted[11,sec,sp]
          if (sum gt 0.0) then begin
             corrected[11,sec,sp] = corrected[11,sec,sp] + sum * 1. 
          endif

       endfor
    endfor


RETURN
END

PRO l_CorrectImages_PolSec, corrected

   distorted = corrected 
   corrected = fltarr (12, 45)

   for sec = 0L, 44L do begin
   
      ;--- if polar bin 0 ---
      if (distorted[0,sec] gt 0.0) then begin
         corrected[0,sec] = corrected[0,sec] + distorted[0,sec] * 0.175 
         corrected[1,sec] = corrected[1,sec] + distorted[0,sec] * 0.205 
         corrected[2,sec] = corrected[2,sec] + distorted[0,sec] * 0.241 
         corrected[3,sec] = corrected[3,sec] + distorted[0,sec] * 0.301 
         corrected[4,sec] = corrected[4,sec] + distorted[0,sec] * 0.078 
      endif
    
      ;--- if polar bin 1 ---
      if (distorted[1,sec] gt 0.0) then begin
         corrected[4,sec] = corrected[4,sec] + distorted[1,sec] * 0.262 
         corrected[5,sec] = corrected[5,sec] + distorted[1,sec] * 0.439 
         corrected[6,sec] = corrected[6,sec] + distorted[1,sec] * 0.299
      endif

      ;--- if polar bin 2 ---
      if (distorted[2,sec] gt 0.0) then begin
         corrected[6,sec] = corrected[6,sec] + distorted[2,sec] * 0.238 
         corrected[7,sec] = corrected[7,sec] + distorted[2,sec] * 0.762 
      endif

      ;--- if polar bin 3 ---
      if (distorted[3,sec] gt 0.0) then begin
         corrected[8,sec] = corrected[8,sec] + distorted[3,sec] * 1.0
      endif

      ;--- if polar bin 4 ---
      if (distorted[4,sec] gt 0.0) then begin
         corrected[9,sec] = corrected[9,sec] + distorted[4,sec] * 1.0
      endif

      ;--- if polar bin 5 ---
      if (distorted[5,sec] gt 0.0) then begin
         corrected[9,sec] = corrected[9,sec] + distorted[5,sec] * 0.409  
         corrected[10,sec] = corrected[10,sec] + distorted[5,sec] * 0.591 
      endif

      ;--- if polar bin 6 ---
      if (distorted[6,sec] gt 0.0) then begin
         corrected[10,sec] = corrected[10,sec] + distorted[6,sec] * 1.0
      endif

      ;--- if polar bin 7 ---
      if (distorted[7,sec] gt 0.0) then begin
         corrected[10,sec] = corrected[10,sec] + distorted[7,sec] * 0.753 
         corrected[11,sec] = corrected[11,sec] + distorted[7,sec] * 0.247 
      endif

      ;--- if polar bin 8,9,10,11 ---
      sum = distorted[8,sec] + distorted[9,sec] + distorted[10,sec] + $
            distorted[11,sec]
      if (sum gt 0.0) then begin
         corrected[11,sec] = corrected[11,sec] + sum * 1. 
      endif

   endfor

RETURN
END
