
;-------------------------------------------------------------------------------
;
;  Unit Name : l_DumpRtns.pro
;
;  Purpose   : File containing routines related to generating 
;              ASCII text files.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;   ELH                               v1.0           Original implementation
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_DumpHdrInfo
;  Description:
;    A generic header documenting the data in the text dumps.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  fhd                   long          I        file handle
;  l_setup               struct        I        generic setup parameters
;  l_pltpos              struct        I        generic plot parameters
;  file_data             string        I        data contents of file
;  filename              string        I        filename  
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  l_LenaPlot.pro
;     PLOTDEFS         MAX_PLOTS        int         G         max # plots per page
;                      MAX_WEB_SPINS    int         G         max # spins per plot
;                                                             when using web interface
;                      NO_CNTS          double      G         no counts indicator
;                      NO_DATA          double      G         no data indicator
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;-------------------------------------------------------------------------------

PRO l_DumpHdrInfo, fhd, l_setup, l_pltpos, filename
COMMON PLOTDEFS, MAX_PLOTS, MAX_WEB_SPINS, NO_CNTS, NO_DATA


   printf, fhd, '============================================================'

   header = 'IMAGE/LENA Dump File: ' + l_pltpos.dmp_hdr_title 
   printf, fhd, header

   mo = 0
   dy = 0
   l_ConvDOY2YMD, l_setup.l_start_dtime[1], l_setup.l_start_dtime[0], mo, dy
   btime = STRING(l_setup.l_start_dtime[0], mo, dy, $
                  l_setup.l_start_dtime[1], $
                  l_setup.l_start_dtime[2], $
                  l_setup.l_start_dtime[3], $
                  l_setup.l_start_dtime[4], $
   FORMAT="(i4,'/',i2.2,'/',i2.2,'  ', '(',i3,')','  ',i2.2,':',i2.2,':',i2.2)")

   printf, fhd, 'User specified data Start Time: ' + btime


   mo = 0
   dy = 0
   l_ConvDOY2YMD, l_setup.l_stop_dtime[1], l_setup.l_stop_dtime[0], mo, dy
   etime = STRING(l_setup.l_stop_dtime[0], mo, dy, $
                  l_setup.l_stop_dtime[1], $
                  l_setup.l_stop_dtime[2], l_setup.l_stop_dtime[3], $
                  l_setup.l_stop_dtime[4], $
   FORMAT="(i4,'/',i2.2,'/',i2.2,'  ','(',i3,')','  ',i2.2,':',i2.2,':',i2.2)")

   printf, fhd, 'User specified data Stop Time: ' + etime

   printf, fhd, ' '

   sw_ver= 'Software Version: ' + l_pltpos.sw_ver
   printf, fhd, sw_ver 


   tme = 'Text Dump Creation Date: ' + systime()
   printf, fhd, tme

   if (l_pltpos.data_source eq 'D') then begin
      ds = 'UDF Definitive'
   endif else begin
      ds = 'UDF Quicklook'
   endelse
   printf, fhd, 'Data Source: ' + ds
   printf, fhd, 'Filename : ' + filename 

   printf, fhd, '============================================================'
   printf, fhd, ' '
   printf, fhd, ' '

   printf, fhd, ' '
   printf, fhd, 'No DATA = ', NO_DATA, ' or -9 '
   printf, fhd, 'No COUNTS = ', NO_CNTS
   printf, fhd, ' '


RETURN
END


;-------------------------------------------------------------------------------
;  Procedure: l_DumpData
;  Description:
;    A generic routine used to write the data to a file.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  filedes               long          I        file handle
;  title                 string        I        title of data
;  data                  float[]       I        data values to be dumped 
;  udfTime               double[]      I        s/c corrected times
;  nitems                long          I        # of records total
;  data_format           long          I        single scalar array or 45 elements 
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;-------------------------------------------------------------------------------

PRO l_DumpData, filedes, title, data, udfTime, nitems, data_format, l_setup


   str = 'Raw Data'
   ;-------------------------------------------
   ; TEMPORARY
   ;-------------------------------------------
   parts_title = STR_SEP(title, ' ')
   if (parts_title[0] eq 'Event') then begin
   if (l_setup.l_count_rate eq 'Y') then begin
      str = ' '
      str = 'Count Rate [Hz]'
   endif

   if (l_setup.l_flux eq 'Y') then begin
      if (l_setup.l_count_rate eq 'Y') then begin
          str = ' '
          str = 'atoms/cm2/s'
      endif else begin
          str = 'efficiency applied, not in HZ'
      endelse
   endif
   endif


   printf, filedes, ' '
   new_title =  '****************** ' + title + ' ******************'
   printf, filedes, new_title 
   values_title = 'Values = ' + str
   printf, filedes, values_title 
   printf, filedes, ' '

   if (data_format eq 45L) then begin

     if (l_setup.l_angle_zero eq 'E') then begin
         ca_str = 'Earth Centered Azimuth'
     endif else begin
       if (l_setup.l_angle_zero eq 'S') then begin
         ca_str = 'Sun Centered Azimuth'
       endif else begin
          if (l_setup.l_angle_zero eq 'M') then begin
             ca_str = 'Moon Centered Azimuth'
          endif else begin
             ca_str = 'Spin Angle'
          endelse
       endelse
     endelse

      sp_str = ca_str + '(' + strcompress(string (l_setup.l_min_spin_angle), /remove_all) + $
               ' to ' +  strcompress(string (l_setup.l_max_spin_angle), /remove_all) + ' degrees)' 
      
      printf, filedes, 'UTC', sp_str, format='((A10,TR4), (A50))'

      str = 'printf, filedes, tmestr, data[*,ii], format=''((A10,TR1),45(e12.3))''

   endif else begin
      printf, filedes, 'UTC', 'TOF Bins (1...32)', $
                format='((A10,TR4), (A37))'
      str = 'printf, filedes, tmestr, data[*,ii], format=''((A10,TR1),32(e12.3))''
   endelse

   printf, filedes, '----------','-------------------------------------------', $
                format='((A10,TR4), (A50))'

   for ii = 0L, nitems - 1L do begin
      tmestr = STRING (udfTime[ii].hour,$
                       udfTime[ii].min, $
                       udfTime[ii].sec, $
                       FORMAT="(i2.2,':',i2.2,':',i2.2)")
      result = execute (str)

   endfor

   printf, filedes, ' '


RETURN
END

