
;-------------------------------------------------------------------------------
;
;  Unit Name : l_DetTicks4Tokar.pro
;
;  Purpose   : To determine the number of major and minor tick
;              marks and their labels.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;  ELH              11/30/01         v1.0.8           Modified to handle general
;                                                     calculations of major and
;                                                     minor tick marks
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;
;  NOTE:  For Tokar plots, at least a minimum of 2 days to plot must be specified
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_DetXTicks4Tokar
;
;  Description:  Determine the X axis major, minor tick labele and markers
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  l_ltt_setup           struct       I         long term trending parameters
;  filter_times          array struct I         user specified time range
;                                               of apogee/perigee times
;  hr_n_secs             double       I         hour in seconds
;  l_pltpos              struct       I         general plotting parameters
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               04/23/03       v1.0.11           Original implementation
;-------------------------------------------------------------------------------

PRO l_DetXTicks4Tokar, l_ltt_setup, filter_times, hr_n_secs, l_pltpos

    MAX_TICKS = 12L

    nitems = n_elements (filter_times)
    time_range = l_ltt_setup.time_range


    ;------------------------------------------
    ; determine the number of days
    ;------------------------------------------
    start_tick = filter_times[0].doy
    stop_tick = filter_times[nitems-1].doy

    ;------------------------------------------
    ; find delta between major tick marks
    ;------------------------------------------
    nontime_deltas = [1, 2, 5, 10, 15, 20, 30, 100, 1000]
    num_ntds = n_elements (nontime_deltas)

    diff = stop_tick - start_tick + 1L

    mtest = -1
    for i = 0, num_ntds - 1 do begin
       if (i eq 7) or (i eq 8) then begin
          for j = 1, 9 do begin
              nt_delta = diff/nontime_deltas[i] * j
              if (mtest lt 0) AND (nt_delta lt MAX_TICKS) then begin
                 mtest = i
              endif
          endfor
       endif else begin
          nt_delta = diff/nontime_deltas[i]
          if (mtest lt 0) AND (nt_delta lt MAX_TICKS) then begin
              mtest = i
          endif
       endelse
    endfor

    delta = nontime_deltas[mtest]
    nticks = (diff/delta) + 1

    maj_xtick_loc = dblarr (nitems)
    xtick_labels = strarr (nitems)

    ;-------------------
    ; doy format
    ;-------------------
    monthly = 1L
 
    ;------------------------------------------------
    ; generate X axis label and tick mark locations
    ;------------------------------------------------
    for i = 0, nitems - 1L do begin
        label = filter_times[i].doy 
        xtick_labels[i] = label 
    endfor
    

    ;------------------------------------------------
    ; duplicate day of year as a result of multiple
    ; apogee/periogee times, determine the first
    ; occurrence and use that 
    ;------------------------------------------------
    rev_xtick_labels = reverse (xtick_labels)

    xtick_idx = uniq (rev_xtick_labels)
    new_xtick_labels = reverse (rev_xtick_labels[xtick_idx])

    maj_xtick_loc = dblarr (nticks)
    xtick_labels = strarr (nticks)


    ;------------------------------------------------
    ; generate labels and locations
    ;------------------------------------------------
    idx = 0L
    i = 0L
    while (idx lt nticks - 1L) do begin
      xtick_labels[idx] = new_xtick_labels[i]
      maj_xtick_loc[idx] = idx * 24L
      idx = idx + 1L
      i = i + delta
    endwhile


    ;------------------------------------------------
    ; store length of X axis and other plot related
    ; information
    ;------------------------------------------------
    XaxisLen = ((n_elements (xtick_labels) - 1L) * 24L)
    l_pltpos.min_time_axis_len = 0 
    l_pltpos.max_time_axis_len = XaxisLen

    l_pltpos.nticks = nticks
    l_pltpos.xtick_labels = xtick_labels
    l_pltpos.xtick_locs = maj_xtick_loc
    l_pltpos.mn_tick_delta = 0

    
RETURN
END

