;-------------------------------------------------------------------------------
;  Procedure : l_DataGap
;  Description:
;      Determine if there is a data gap.
;
;  Return Value:  type = long
;  Value                         Description
;  -------------------------     ------------------------------
;  0                             NO data gap found
;  1                             data gap found
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  next_start_time       double        I        start time of next record
;  current_stop_time     double        I        stop time of current record
;  event_time            double        I        current event data time
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH                               v1.0             Original implementation
;  ELH               09/05/0         v1.0.7           Added check if the event
;                                                     time is both less then the
;                                                     current and end comparison
;                                                     times
;-------------------------------------------------------------------------------
FUNCTION l_DataGap, next_start_time, current_stop_time, event_time

    status = 0L

    diff = next_start_time - current_stop_time
    ;---------------------------------------------------------
    ; if there is a data gap
    ;---------------------------------------------------------
    if (diff gt 240) then begin
       if ((event_time ge current_stop_time) and $
           (event_time le next_start_time)) then begin
            status = 1L
       endif
    endif else begin
       ;---------------------------------------------------------
       ; if there is extra event data with no matching packets
       ;---------------------------------------------------------
       if ((event_time ge current_stop_time) and $
           (event_time le next_start_time)) then begin
            status = 1L
       endif else begin
          ;---------------------------------------------------------
          ; if event time is before both the current and the end time
          ;---------------------------------------------------------
          if (event_time lt current_stop_time) AND (event_time lt next_start_time) then begin
             status = 1L
          endif
       endelse
    endelse

    RETURN, status
END


