;-------------------------------------------------------------------------------
;
;  Unit Name : l_BinnedTerm.pro
;
;  Purpose   : Free memory allocated.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  John Park                                         Original Implementation
;  ELH               04/01           v1.0            added background (ROI0)
;  ELH               07/05/01        v1.0            Added freeing of ptrs for
;                                                    text dumps
;  ELH               08/31/01       v1.0.7           Removed freeing of unused 
;                                                    fields from binned data struct
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_BinnedTerm
;
;  Description: Free memory allocated for binned data storage.
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  binndata              struct *      I        pointers to binned data structures
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               04/23/03       v1.0.11           Original implementation
;-------------------------------------------------------------------------------
PRO l_BinnedTerm, binndata

;----------------------------------------
; remove heap variables
;----------------------------------------

;--------------------
; time
;--------------------
if (ptr_valid(binndata.timePtr)) then begin
    ptr_free, binndata.timePtr
endif

if (ptr_valid(binndata.filledTimePtr)) then begin
    ptr_free, binndata.filledTimePtr
endif

if (ptr_valid(binndata.spinTimePtr)) then begin
    ptr_free, binndata.spinTimePtr
endif

if (ptr_valid(binndata.startUdfTimePtr)) then begin
    ptr_free, binndata.startUdfTimePtr
endif

if (ptr_valid(binndata.filledStartUdfTimePtr)) then begin
    ptr_free, binndata.filledStartUdfTimePtr
endif

if (ptr_valid(binndata.stopUdfTimePtr)) then begin
    ptr_free, binndata.stopUdfTimePtr
endif

;--------------------
; Hydrogen & Oxygen 
;--------------------
if (ptr_valid(binndata.m0lePtr)) then begin
    ptr_free, binndata.m0lePtr
endif

if (ptr_valid(binndata.filledM0lePtr)) then begin
    ptr_free, binndata.filledM0lePtr
endif

if (ptr_valid(binndata.m0leExtraPtr)) then begin
    ptr_free, binndata.m0leExtraPtr
endif

if (ptr_valid(binndata.m0leDmpPtr)) then begin
    ptr_free, binndata.m0leDmpPtr
endif

if (ptr_valid(binndata.m0cePtr)) then begin
    ptr_free, binndata.m0cePtr
endif

if (ptr_valid(binndata.filledM0cePtr)) then begin
    ptr_free, binndata.filledM0cePtr
endif

if (ptr_valid(binndata.m0ceExtraPtr)) then begin
    ptr_free, binndata.m0ceExtraPtr
endif

if (ptr_valid(binndata.m0ceDmpPtr)) then begin
    ptr_free, binndata.m0ceDmpPtr
endif

if (ptr_valid(binndata.m0uePtr)) then begin
    ptr_free, binndata.m0uePtr
endif

if (ptr_valid(binndata.filledM0uePtr)) then begin
    ptr_free, binndata.filledM0uePtr
endif

if (ptr_valid(binndata.m0ueExtraPtr)) then begin
    ptr_free, binndata.m0ueExtraPtr
endif

if (ptr_valid(binndata.m0ueDmpPtr)) then begin
    ptr_free, binndata.m0ueDmpPtr
endif

if (ptr_valid(binndata.m1lePtr)) then begin
    ptr_free, binndata.m1lePtr
endif

if (ptr_valid(binndata.filledM1lePtr)) then begin
    ptr_free, binndata.filledM1lePtr
endif

if (ptr_valid(binndata.m1leExtraPtr)) then begin
    ptr_free, binndata.m1leExtraPtr
endif

if (ptr_valid(binndata.m1leDmpPtr)) then begin
    ptr_free, binndata.m1leDmpPtr
endif

if (ptr_valid(binndata.m1cePtr)) then begin
    ptr_free, binndata.m1cePtr
endif

if (ptr_valid(binndata.filledM1cePtr)) then begin
    ptr_free, binndata.filledM1cePtr
endif

if (ptr_valid(binndata.m1ceExtraPtr)) then begin
    ptr_free, binndata.m1ceExtraPtr
endif

if (ptr_valid(binndata.m1ceDmpPtr)) then begin
    ptr_free, binndata.m1ceDmpPtr
endif

if (ptr_valid(binndata.m1uePtr)) then begin
    ptr_free, binndata.m1uePtr
endif

if (ptr_valid(binndata.filledM1uePtr)) then begin
    ptr_free, binndata.filledM1uePtr
endif

if (ptr_valid(binndata.m1ueExtraPtr)) then begin
    ptr_free, binndata.m1ueExtraPtr
endif

if (ptr_valid(binndata.m1ueDmpPtr)) then begin
    ptr_free, binndata.m1ueDmpPtr
endif


;--------------------
; raw telemetry
;--------------------
if (ptr_valid(binndata.m0RawPtr)) then begin
    ptr_free, binndata.m0RawPtr
endif

if (ptr_valid(binndata.filledM0RawPtr)) then begin
    ptr_free, binndata.filledM0RawPtr
endif

if (ptr_valid(binndata.m0RawExtraPtr)) then begin
    ptr_free, binndata.m0RawExtraPtr
endif


if (ptr_valid(binndata.m1RawPtr)) then begin
    ptr_free, binndata.m1RawPtr
endif

if (ptr_valid(binndata.filledM1RawPtr)) then begin
    ptr_free, binndata.filledM1RawPtr
endif

if (ptr_valid(binndata.m1RawExtraPtr)) then begin
    ptr_free, binndata.m1RawExtraPtr
endif


;--------------------
; count rate
;--------------------
if (ptr_valid(binndata.m0CntPtr)) then begin
    ptr_free, binndata.m0CntPtr
endif

if (ptr_valid(binndata.filledM0CntPtr)) then begin
    ptr_free, binndata.filledM0CntPtr
endif

if (ptr_valid(binndata.m0CntExtraPtr)) then begin
    ptr_free, binndata.m0CntExtraPtr
endif

if (ptr_valid(binndata.m1CntPtr)) then begin
    ptr_free, binndata.m1CntPtr
endif

if (ptr_valid(binndata.filledM1CntPtr)) then begin
    ptr_free, binndata.filledM1CntPtr
endif

if (ptr_valid(binndata.m1CntExtraPtr)) then begin
    ptr_free, binndata.m1CntExtraPtr
endif


;--------------------
; number flux
;--------------------
if (ptr_valid(binndata.m0FlxPtr)) then begin
    ptr_free, binndata.m0FlxPtr
endif

if (ptr_valid(binndata.m1FlxPtr)) then begin
    ptr_free, binndata.m1FlxPtr
endif


;--------------------
; steering voltage
;--------------------
if (ptr_valid(binndata.steervPtr)) then begin
    ptr_free, binndata.steervPtr
endif

if (ptr_valid(binndata.filledSteervPtr)) then begin
    ptr_free, binndata.filledSteervPtr
endif

if (ptr_valid(binndata.strStUdfTimePtr)) then begin
    ptr_free, binndata.strStUdfTimePtr
endif

if (ptr_valid(binndata.filledStrStUdfTimePtr)) then begin
    ptr_free, binndata.filledStrStUdfTimePtr
endif

if (ptr_valid(binndata.strSpUdfTimePtr)) then begin
    ptr_free, binndata.strSpUdfTimePtr
endif

if (ptr_valid(binndata.filledStrSpUdfTimePtr)) then begin
    ptr_free, binndata.filledStrSpUdfTimePtr
endif

;--------------------
; valid events 
;--------------------
if (ptr_valid(binndata.vePtr)) then begin
    ptr_free, binndata.vePtr
endif

if (ptr_valid(binndata.filledVePtr)) then begin
    ptr_free, binndata.filledVePtr
endif

if (ptr_valid(binndata.veExtraPtr)) then begin
    ptr_free, binndata.veExtraPtr
endif

if (ptr_valid(binndata.veDmpPtr)) then begin
    ptr_free, binndata.veDmpPtr
endif

;--------------------
; final m0 and m1 
;--------------------
if (ptr_valid(binndata.m0Ptr)) then begin
    ptr_free, binndata.m0Ptr
endif

if (ptr_valid(binndata.filledM0Ptr)) then begin
    ptr_free, binndata.filledM0Ptr
endif

if (ptr_valid(binndata.m0ExtraPtr)) then begin
    ptr_free, binndata.m0ExtraPtr
endif

if (ptr_valid(binndata.m0DmpPtr)) then begin
    ptr_free, binndata.m0DmpPtr
endif


if (ptr_valid(binndata.m1Ptr)) then begin
    ptr_free, binndata.m1Ptr
endif

if (ptr_valid(binndata.filledM1Ptr)) then begin
    ptr_free, binndata.filledM1Ptr
endif


if (ptr_valid(binndata.m1ExtraPtr)) then begin
    ptr_free, binndata.m1ExtraPtr
endif

if (ptr_valid(binndata.m1DmpPtr)) then begin
    ptr_free, binndata.m1DmpPtr
endif


if (ptr_valid(binndata.hydrogen_raw_cnts)) then begin
    ptr_free, binndata.hydrogen_raw_cnts
endif

if (ptr_valid(binndata.hydrogen_raw_cnts_e0)) then begin
    ptr_free, binndata.hydrogen_raw_cnts_e0
endif

if (ptr_valid(binndata.hydrogen_raw_cnts_e1)) then begin
    ptr_free, binndata.hydrogen_raw_cnts_e1
endif

if (ptr_valid(binndata.hydrogen_raw_cnts_e2)) then begin
    ptr_free, binndata.hydrogen_raw_cnts_e2
endif

if (ptr_valid(binndata.oxygen_raw_cnts)) then begin
    ptr_free, binndata.oxygen_raw_cnts
endif

if (ptr_valid(binndata.oxygen_raw_cnts_e0)) then begin
    ptr_free, binndata.oxygen_raw_cnts_e0
endif

if (ptr_valid(binndata.oxygen_raw_cnts_e1)) then begin
    ptr_free, binndata.oxygen_raw_cnts_e1
endif

if (ptr_valid(binndata.oxygen_raw_cnts_e2)) then begin
    ptr_free, binndata.oxygen_raw_cnts_e2
endif

if (ptr_valid(binndata.corr_scl_H)) then begin
    ptr_free, binndata.corr_scl_H
endif

if (ptr_valid(binndata.corr_scl_H_e0)) then begin
    ptr_free, binndata.corr_scl_H_e0
endif

if (ptr_valid(binndata.corr_scl_H_e1)) then begin
    ptr_free, binndata.corr_scl_H_e1
endif

if (ptr_valid(binndata.corr_scl_H_e2)) then begin
    ptr_free, binndata.corr_scl_H_e2
endif

if (ptr_valid(binndata.corr_scl_O)) then begin
    ptr_free, binndata.corr_scl_O
endif

if (ptr_valid(binndata.corr_scl_O_e0)) then begin
    ptr_free, binndata.corr_scl_O_e0
endif

if (ptr_valid(binndata.corr_scl_O_e1)) then begin
    ptr_free, binndata.corr_scl_O_e1
endif

if (ptr_valid(binndata.corr_scl_O_e2)) then begin
    ptr_free, binndata.corr_scl_O_e2
endif

if (ptr_valid(binndata.bkcUdfTimePtr)) then begin
    ptr_free, binndata.bkcUdfTimePtr
endif


RETURN
END
