;-------------------------------------------------------------------------------
;
;  Unit Name : l_BinnedReadSetup.pro
;
;  Purpose   : Read the setup parameters for the binned data.
;
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  John Park         1999                          Original implmentation
;  ELH               5/01                          Added comments
;  ELH               01/02   v1.0.8                Changed l_binned_nplots to 
;                                                  nplots to be consistent with 
;                                                  other structs
;                                                   . eliminated separate color 
;                                                     min/max, all_masses
;
;
;  File Revision Number:   %I%
;  File Last Modified  :   %E%  %T%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;  Procedure: l_BinnedReadSetup
;
;  Description: Reads the setup file for binned data specific options
;
;  Return Value:  type =
;  Value                         Description
;  -------------------------     ------------------------------
;  None
;
;  Argument List:
;  Name                  Type         Use       Description
;  -----------------     ------       ---       ---------------------------
;  l_plot_setup          struct        I        binned setup parameters
;  l_setup_file          string        I        runtime setup file name
;
;
;  External Variables:
;  Source              Name            Type        Use        Description
;  ---------------     ---------       ----        ----       --------------------
;  None
;
;  Development History:
;  Author             Date           Build            Description of Change
;  --------------   ---------       --------         -------------------------
;  ELH               04/23/03       v1.0.11           Original implementation
;  ELH                05/04         v1.0.11           Convert input string to
;                                                     lowercase
;-------------------------------------------------------------------------------

PRO l_BinnedReadSetup, l_plot_setup, l_setup_file

    ;--------------------------------
    ; binned setup data parameters 
    ;--------------------------------
    l_plot_setup = {                               $
        addedStartFlag                  : 0L,      $  ;add spins to user start time
        addedStopFlag                   : 0L,      $  ;add spins to user stop time
        l_binned_plot_type              : 'T',     $  ;store data in time or spin format 
        use_binned                      : 'N',     $  ;use binned data?
        color_min                       : -1.0D,   $  ;color scale minimum
        color_max                       : 2.0D,    $  ;color scale maximum
        merge                           : 'N',     $  ;merge the masses, energies
        energy0                         : 'N',     $  ;use energy 0
        energy1                         : 'N',     $  ;use energy 1 
        energy2                         : 'N',     $  ;use energy 2 
        oxygen                          : 'N',     $  ;use oxygen
        oe0_eV                          : 30L,     $  ;oxygen energy 0 value
        oe1_eV                          : 65L,     $  ;oxygen energy 1 value
        oe2_eV                          : 200L,    $  ;oxygen energy 2 value
        l_binned_mass0_energy_lower     : 'N',     $  ;use hydrogen E0
        l_binned_mass0_energy_center    : 'N',     $  ;use hydrogen E1
        l_binned_mass0_energy_upper     : 'N',     $  ;use hydrogen E2
        hydrogen                        : 'N',     $  ;use hydrogen
        he0_eV                          : 20L,     $  ;hydrogen energy 0 value
        he1_eV                          : 65L,     $  ;hydrogen energy 1 value
        he2_eV                          : 200L,    $  ;hydrogen energy 2 value
        l_binned_mass1_energy_lower     : 'N',     $  ;use oxygen E0
        l_binned_mass1_energy_center    : 'N',     $  ;use oxygen E1
        l_binned_mass1_energy_upper     : 'N',     $  ;use oxygen E2
        background                      : 'N',     $  ;do background correction
        l_binned_bkgrnd_color_min       : -1.0D,   $  ;background corrected color scale min
        l_binned_bkgrnd_color_max       : 2.0D,    $  ;background corrected color scale max
        nplots                          : 0L,      $  ;number of plots to be plotted
        l_binned_raw                    : 'N',     $  ;no conversion just raw counts
        l_binned_cntrate                : 'N',     $  ;convert to count rate
        l_binned_numflux                : 'N',     $  ;convert to number flux 
        l_binned_plot_interp            : 'N',     $  ;N, BILINEAR, NEIGHBOR
        l_binned_collapse               : 'N',     $  ;collapse data
        l_binned_collapse_method        : 'SUM',   $  ;N, AVG, SUM
        l_binned_polar_start            : -45,     $  ;polar begin angle
        l_binned_polar_stop             :  45,     $  ;polar end angle
        l_binned_spinsec_start          : -180,    $  ;spin sector begin angle
        l_binned_spinsec_stop           :  180,    $  ;spin sector end angle
        l_binned_num_mass               :  [0L,0L],$  
        l_binned_scale_plot             :  'N',    $  ;color scale
        l_binned_raw_min                :  0L,     $  ;min value of raw counts
        l_binned_raw_max                :  0L,     $  ;max value of raw counts
        l_binned_cntrate_min            :  0.0,    $  ;min value of count rate
        l_binned_cntrate_max            :  0.0,    $  ;max value of count rate
        l_binned_numflux_min            :  0.0,    $  ;min value of number flux
        l_binned_numflux_max            :  0.0     $  ;max value of number flux
    }


    ;----------------------------------------
    ; read binned data setup parameters
    ;----------------------------------------

    openr, inlun, /get_lun, l_setup_file

    l_plot_setup.l_binned_num_mass[0] = 0L
    l_plot_setup.l_binned_num_mass[1] = 0L
    l_plot_setup.nplots      = 0L

    line = ' '
    while not EOF(inlun) do begin;While there is text left, output it.
        readf, inlun, line
    ;   line = STRUPCASE(line)
        IF (STRMID(line, 0, 1) ne ';') and (STRLEN(line) gt 0) then begin
            parts = STR_SEP(line, ' ')

            if (n_elements (parts) gt 2) then begin
            case STRLOWCASE (parts[0]) of

            'l_binned' : begin
                l_plot_setup.use_binned=STRUPCASE(parts[2])
             end

            'l_binned_merge' : begin
                l_plot_setup.merge=STRUPCASE(parts[2])
             end

            'l_binned_energy0' : begin
                l_plot_setup.energy0=STRUPCASE(parts[2])
             end

            'l_binned_energy1' : begin
                l_plot_setup.energy1=STRUPCASE(parts[2])
             end

            'l_binned_energy2' : begin
                l_plot_setup.energy2=STRUPCASE(parts[2])
             end

            'l_binned_plot_type' : begin
                l_plot_setup.l_binned_plot_type=STRUPCASE(parts[2])
             end

            'l_binned_oxygen'    : begin
                l_plot_setup.oxygen=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end

            'l_binned_color_min'    : begin
                l_plot_setup.color_min=double(parts[2])
            end

            'l_binned_color_max'    : begin
                l_plot_setup.color_max=double(parts[2])
            end

            'l_binned_mass0_energy_lower'    : begin
                l_plot_setup.l_binned_mass0_energy_lower=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_mass0_energy_center'    : begin
                l_plot_setup.l_binned_mass0_energy_center=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_mass0_energy_upper'    : begin
                l_plot_setup.l_binned_mass0_energy_upper=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_hydrogen'    : begin
                l_plot_setup.hydrogen=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_mass1_energy_lower'    : begin
                l_plot_setup.l_binned_mass1_energy_lower=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_mass1_energy_center'    : begin
                l_plot_setup.l_binned_mass1_energy_center=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots =  l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_mass1_energy_upper'    : begin
                l_plot_setup.l_binned_mass1_energy_upper=STRUPCASE(parts[2])
                if STRUPCASE(parts[2]) eq 'Y' then begin
                   l_plot_setup.nplots = l_plot_setup.nplots + 1L
                endif
            end


            'l_binned_bkgrnd'    : begin
                l_plot_setup.background=STRUPCASE(parts[2])
            end

            'l_binned_bkgrnd_color_min'    : begin
                l_plot_setup.l_binned_bkgrnd_color_min=double(parts[2])
            end

            'l_binned_bkgrnd_color_max'    : begin
                l_plot_setup.l_binned_bkgrnd_color_max=double(parts[2])
            end

            'l_binned_raw'         : l_plot_setup.l_binned_raw=parts[2]
            'l_binned_number_flux' : l_plot_setup.l_binned_numflux=parts[2]
            'l_binned_plot_interp' : l_plot_setup.l_binned_plot_interp=parts[2] ;BILINEAR, NEIGHBOR
            'l_binned_collapse'    : l_plot_setup.l_binned_collapse=parts[2] 
            'l_binned_collapse_method' : l_plot_setup.l_binned_collapse_method=parts[2] 
            'l_binned_polar_start' : l_plot_setup.l_binned_polar_start=parts[2]
            'l_binned_polar_stop'  : l_plot_setup.l_binned_polar_stop=parts[2]
            'l_binned_spinsec_start' : l_plot_setup.l_binned_spinsec_start=parts[2]
            'l_binned_spinsec_stop'  : l_plot_setup.l_binned_spinsec_stop=parts[2]
            'l_binned_scale_plot'    : l_plot_setup.l_binned_scale_plot=parts[2]
            'l_binned_raw_min'     : l_plot_setup.l_binned_raw_min=parts[2]
            'l_binned_raw_max'     : l_plot_setup.l_binned_raw_max=parts[2]
            'l_binned_cntrate_min' : l_plot_setup.l_binned_cntrate_min=parts[2]
            'l_binned_cntrate_max' : l_plot_setup.l_binned_cntrate_max=parts[2]
            'l_binned_numflux_min' : l_plot_setup.l_binned_numflux_min=parts[2]
            'l_binned_numflux_max' : l_plot_setup.l_binned_numflux_max=parts[2]
    
            else: begin
                     ;print,  'Unknown option : ', parts[0] 
                  end
            endcase;End of CASE statement.
            endif
        endif
    endwhile
    

    close, inlun
    free_lun, inlun

    np = 0L
    if (l_plot_setup.use_binned eq 'Y') then begin
       if (l_plot_setup.merge eq 'Y') then begin
           np = 1L
       endif else begin
          if (l_plot_setup.hydrogen eq 'Y') then begin
              if (l_plot_setup.energy0 eq 'Y') then np = np + 1L
              if (l_plot_setup.energy1 eq 'Y') then np = np + 1L
              if (l_plot_setup.energy2 eq 'Y') then np = np + 1L
          endif

          if (l_plot_setup.oxygen eq 'Y') then begin
              if (l_plot_setup.energy0 eq 'Y') then np = np + 1L
              if (l_plot_setup.energy1 eq 'Y') then np = np + 1L
              if (l_plot_setup.energy2 eq 'Y') then np = np + 1L
          endif
       endelse
    endif

    l_plot_setup.nplots = np


    if (l_plot_setup.use_binned eq 'N') then l_plot_setup.nplots = 0L
    
RETURN
END
