;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
l_pltpos = {           $
   window_width: 0L,   $
   window_height: 0L,  $
   yin        : 9.9,   $
   xin        : 8.2,   $
   ps_xoffset : 0.50,  $
   ps_yoffset : 1.30,  $
   ps_xsize   : 7.70,  $
   ps_ysize   : 9.00,  $
   axis_size  : 6.35,  $
   xdel       : 0.0D,  $
   xpltmn     : 0.0D,  $
   xpltmx     : 0.0D,  $
   ypltmn     : 0.0D,  $
   ypltmx     : 0.0D,  $
   top_ypltmn : 0.0D,  $
   top_ypltmx : 0.0D,  $
   doc_ymn    : 0.0D,  $
   doc_ymx    : 0.0D,  $
   ydel       : 0.0D,  $
   yspace     : 0.0D,  $
   lg_font    : 1.1D,  $
   md_font    : 1.0D,  $
   sm_font    : 0.9D,  $
   xsm_font   : 0.5D,  $
   plot_font  : 1.2D,  $
   xmn_tick    : 1L,   $
   ymn_tick    : 1L,   $
   nticks     : 6L,    $
   data_source: '',    $
   filename   : '',    $
   ps         : 'N',   $
   linePlots  : 'N',   $
   xtick_labels : strarr (12), $
   sw_ver       : 'lena_dps_v1.0.0', $
   color_table  : 1, $
   ang_zero    : '' $
}
l_udf_times = { UDF_TIMES_STRUCT, $
               year: 0L, $
               doy : 0L, $
               hour: 0L, $
               min : 0L, $
               sec : 0L, $
               msec: 0L  $
              }
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
re = 6371.0
start_time = lonarr(5)
stop_time = lonarr(5)
start_time[0] = 2001
start_time[1] = 139
start_time[2] = 2
start_time[3] = 48
start_time[4] = 0
stop_time[0] = 2001
stop_time[1] = 139
stop_time[2] = 2
stop_time[3] = 53
stop_time[4] = 0
inst = 'OA'
expr = 'ORBIT'
vinst = 'IMOORBIT'
data_source = ' '
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
openw, opt, 'perigee_apogee.temp.list', /get_lun
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
print, start_time
print, stop_time
;nrec = l_UdfGetNumRec(start_time, stop_time, inst, expr, vinst, data_source)
;print, 'nrec = ', nrec
l_OARead, l_oa, start_time, stop_time, l_pltpos
;
;------------------------------------------------------------------------------
; get the first three data sets
;------------------------------------------------------------------------------
;
save_time_1 = lonarr(6)
save_time_2 = lonarr(6)
save_time_3 = lonarr(6)
;
xgei = ((*l_oa.gci_x_pos_ptr)[0]) / re
ygei = ((*l_oa.gci_y_pos_ptr)[0]) / re
zgei = ((*l_oa.gci_z_pos_ptr)[0]) / re
sat_re_1 = sqrt(xgei*xgei + ygei*ygei + zgei*zgei)
time = ConvSec2Arr ((*l_oa.tme_ptr)[0], start_time[0])
l_ConvDOY2YMD, time[1], time[0], mn, dom
save_time_1[0] = time[0]
save_time_1[1] = mn
save_time_1[2] = dom
save_time_1[3] = time[2]
save_time_1[4] = time[3]
save_time_1[5] = time[4]
;print, save_time_1, sat_re_1
;
xgei = ((*l_oa.gci_x_pos_ptr)[1]) / re
ygei = ((*l_oa.gci_y_pos_ptr)[1]) / re
zgei = ((*l_oa.gci_z_pos_ptr)[1]) / re
sat_re_2 = sqrt(xgei*xgei + ygei*ygei + zgei*zgei)
time = ConvSec2Arr ((*l_oa.tme_ptr)[1], start_time[0])
l_ConvDOY2YMD, time[1], time[0], mn, dom
save_time_2[0] = time[0]
save_time_2[1] = mn
save_time_2[2] = dom
save_time_2[3] = time[2]
save_time_2[4] = time[3]
save_time_2[5] = time[4]
;print, save_time_2, sat_re_2
;
xgei = ((*l_oa.gci_x_pos_ptr)[2]) / re
ygei = ((*l_oa.gci_y_pos_ptr)[2]) / re
zgei = ((*l_oa.gci_z_pos_ptr)[2]) / re
sat_re_3 = sqrt(xgei*xgei + ygei*ygei + zgei*zgei)
time = ConvSec2Arr ((*l_oa.tme_ptr)[2], start_time[0])
l_ConvDOY2YMD, time[1], time[0], mn, dom
save_time_3[0] = time[0]
save_time_3[1] = mn
save_time_3[2] = dom
save_time_3[3] = time[2]
save_time_3[4] = time[3]
save_time_3[5] = time[4]
;print, save_time_3, sat_re_3
;
;------------------------------------------------------------------------------
; see if they contain apogee or perigee
;------------------------------------------------------------------------------
;
if ((sat_re_1 le sat_re_2)  and  (sat_re_3 le sat_re_2)) then begin
   if (sat_re_2 gt 8.00) then begin
   print, format='(''apogee:  '', i6, 5i3.2, f)', save_time_2, sat_re_2
   printf, opt, format='(''apogee:  '', i6, 5i3.2, f)', save_time_2, sat_re_2
   endif
endif else if ((sat_re_1 ge sat_re_2)  and  (sat_re_3 ge sat_re_2)) then begin
   if (sat_re_2 lt 2.00) then begin
   print, format='(''perigee: '', i6, 5i3.2, f)', save_time_2, sat_re_2
   printf, opt, format='(''perigee: '', i6, 5i3.2, f)', save_time_2, sat_re_2
   endif
endif
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
start = 3
for ndays = 139, 366 do begin
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
for irec=start,nrec-1 do begin
   sat_re_1 = sat_re_2
   sat_re_2 = sat_re_3
   for ii=0,5 do begin
      save_time_1[ii] = save_time_2[ii]
      save_time_2[ii] = save_time_3[ii]
   endfor
   xgei = ((*l_oa.gci_x_pos_ptr)[irec]) / re
   ygei = ((*l_oa.gci_y_pos_ptr)[irec]) / re
   zgei = ((*l_oa.gci_z_pos_ptr)[irec]) / re
   sat_re_3 = sqrt(xgei*xgei + ygei*ygei + zgei*zgei)
   time = ConvSec2Arr ((*l_oa.tme_ptr)[irec], start_time[0])
   l_ConvDOY2YMD, time[1], time[0], mn, dom
   save_time_3[0] = time[0]
   save_time_3[1] = mn
   save_time_3[2] = dom
   save_time_3[3] = time[2]
   save_time_3[4] = time[3]
   save_time_3[5] = time[4]
   ;print, save_time_3, sat_re_3
   if ((sat_re_1 le sat_re_2)  and  (sat_re_3 le sat_re_2)) then begin
      if (sat_re_2 gt 8.00) then begin
      print, format='(''apogee:  '', i6, 5i3.2, f)', save_time_2, sat_re_2
      printf, opt, format='(''apogee:  '', i6, 5i3.2, f)', save_time_2, sat_re_2
      endif
   endif else if ((sat_re_1 ge sat_re_2) and (sat_re_3 ge sat_re_2)) then begin
      if (sat_re_2 lt 2.00) then begin
      print, format='(''perigee: '', i6, 5i3.2, f)', save_time_2, sat_re_2
      printf, opt, format='(''perigee: '', i6, 5i3.2, f)', save_time_2, sat_re_2
      endif
   endif
endfor
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
l_OATerm, l_oa
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
start_time[1] = start_time[1] + 1
stop_time[1] = stop_time[1] + 1
nrec = l_UdfGetNumRec(start_time, stop_time, inst, expr, vinst, data_source)
print, 'nrec = ', nrec
l_OARead, l_oa, start_time, stop_time, l_pltpos
start = 0
;
endfor    ; for ndays = 139,366 do begin
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
free_lun, opt
;
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;
end
